/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.preset;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.preset.PresetClient;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.client.CPRequestPresetSync;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class PresetsManagerClient {
    private final List<PresetClient> presets = new ArrayList<PresetClient>(5);

    public void registerPreset(PresetClient preset) {
        this.presets.add(preset);
    }

    public void presetsVersionsReceived(long[] data) {
        OxygenHelperClient.addIOTask(() -> {
            OxygenMain.LOGGER.info("Presets loading started...");
            String folder = CommonReference.getGameFolder() + "/config/oxygen/data/client/worlds/" + data[0] + "/";
            for (PresetClient preset : this.presets) {
                if (preset.loadVersionId(folder + preset.getDomain() + "/presets/")) {
                    OxygenMain.LOGGER.info("Preset <{}> version id loaded successfully.", (Object)preset.getDisplayName());
                    continue;
                }
                OxygenMain.LOGGER.error("Failed to load preset <{}> version id.", (Object)preset.getDisplayName());
            }
            int index = 1;
            for (PresetClient preset : this.presets) {
                if (preset.getVersionId() != data[index++]) {
                    OxygenMain.network().sendToServer(new CPRequestPresetSync(preset.getId()));
                    OxygenMain.LOGGER.info("Preset <{}> is outdated, sync requested.", (Object)preset.getDisplayName());
                    continue;
                }
                OxygenMain.LOGGER.info("Preset <{}> is up-to-date, loading...", (Object)preset.getDisplayName());
                if (preset.load(folder + preset.getDomain() + "/presets/")) {
                    OxygenMain.LOGGER.info("Preset <{}> loaded successfully.", (Object)preset.getDisplayName());
                    continue;
                }
                OxygenMain.LOGGER.error("Failed to load preset <{}>.", (Object)preset.getDisplayName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawPresetReceived(ByteBuf buffer) {
        try {
            long worldId = buffer.readLong();
            byte presetId = buffer.readByte();
            String folder = CommonReference.getGameFolder() + "/config/oxygen/data/client/worlds/" + worldId + "/";
            for (PresetClient preset : this.presets) {
                if (preset.getId() != presetId) continue;
                OxygenMain.LOGGER.info("Received raw preset <{}> data, processing...", (Object)preset.getDisplayName());
                preset.read(buffer);
                OxygenHelperClient.addIOTask(() -> {
                    if (preset.save(folder + preset.getDomain() + "/presets/")) {
                        OxygenMain.LOGGER.info("Preset <{}> saved successfully.", (Object)preset.getDisplayName());
                    } else {
                        OxygenMain.LOGGER.error("Failed to save preset <{}>.", (Object)preset.getDisplayName());
                    }
                    if (preset.reloadAfterSave()) {
                        OxygenMain.LOGGER.info("Reloading preset <{}>...", (Object)preset.getDisplayName());
                        if (preset.load(folder + preset.getDomain() + "/presets/")) {
                            OxygenMain.LOGGER.info("Preset <{}> loaded successfully.", (Object)preset.getDisplayName());
                        } else {
                            OxygenMain.LOGGER.error("Failed to load preset <{}>.", (Object)preset.getDisplayName());
                        }
                    }
                });
            }
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }
}

