/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.client.privilege;

import austeretony.oxygen_core.client.OxygenManagerClient;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.privilege.EnumPrivilegeFileKey;
import austeretony.oxygen_core.common.privilege.Privilege;
import austeretony.oxygen_core.common.privilege.PrivilegedGroup;
import austeretony.oxygen_core.common.privilege.PrivilegedGroupImpl;
import austeretony.oxygen_core.common.util.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class PrivilegesLoaderClient {
    public static void loadPrivilegeDataAsync() {
        OxygenHelperClient.addIOTask(() -> PrivilegesLoaderClient.loadPrivilegedGroup());
    }

    private static void loadPrivilegedGroup() {
        block5: {
            String folder = OxygenHelperClient.getDataFolder() + "/client/players/" + OxygenHelperClient.getPlayerUUID() + "/privileges/group.json";
            Path path = Paths.get(folder, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    JsonObject groupObject = JsonUtils.getExternalJsonData(folder).getAsJsonObject();
                    long groupId = groupObject.get(EnumPrivilegeFileKey.ID.name).getAsLong();
                    if (groupId == OxygenManagerClient.instance().getPrivilegesManager().getGroupId()) {
                        OxygenManagerClient.instance().getPrivilegesManager().setPrivelegedGroup(PrivilegedGroupImpl.deserializeClient(groupObject));
                        break block5;
                    }
                    OxygenMain.LOGGER.info("Client privileged group id mismatch with id recieved from server.");
                    OxygenManagerClient.instance().getPrivilegesManager().requestGroupSync();
                }
                catch (IOException exception) {
                    OxygenMain.LOGGER.error("Privileged group loading failed.");
                    exception.printStackTrace();
                }
            } else {
                OxygenMain.LOGGER.info("Privileged group data file not exist.");
                OxygenManagerClient.instance().getPrivilegesManager().requestGroupSync();
            }
        }
    }

    public static void savePrivilegedGroupAsync() {
        OxygenHelperClient.addIOTask(() -> PrivilegesLoaderClient.savePrivilegedGroup());
    }

    public static void savePrivilegedGroup() {
        String folder = OxygenHelperClient.getDataFolder() + "/client/players/" + OxygenHelperClient.getPlayerUUID() + "/privileges/group.json";
        Path path = Paths.get(folder, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        try {
            PrivilegedGroup group = OxygenManagerClient.instance().getPrivilegesManager().getPrivilegedGroup();
            JsonObject jsonObject = new JsonObject();
            jsonObject.add(EnumPrivilegeFileKey.ID.name, (JsonElement)new JsonPrimitive((Number)group.getId()));
            jsonObject.add(EnumPrivilegeFileKey.NAME.name, (JsonElement)new JsonPrimitive(group.getName()));
            JsonArray privilegesArray = new JsonArray();
            for (Privilege privilege : group.getPrivileges()) {
                privilegesArray.add((JsonElement)privilege.serialize());
            }
            jsonObject.add(EnumPrivilegeFileKey.PRIVILEGES.name, (JsonElement)privilegesArray);
            JsonUtils.createExternalJsonFile(folder, (JsonElement)jsonObject);
            OxygenMain.LOGGER.info("Saved privileged group.");
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("Privileged groups saving failed.");
            exception.printStackTrace();
        }
    }
}

