/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.api.command;

import austeretony.oxygen_core.common.command.ArgumentExecutor;
import austeretony.oxygen_core.common.command.ArgumentParameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public abstract class AbstractArgumentExecutor
implements ArgumentExecutor {
    public final String name;
    private Set<ArgumentParameter> params;

    public AbstractArgumentExecutor(String argument) {
        this.name = argument;
    }

    public AbstractArgumentExecutor(String argument, boolean hasParams) {
        this(argument);
        if (hasParams) {
            this.params = new HashSet<ArgumentParameter>(10);
        }
        this.getParams(this.params);
    }

    @Override
    public String getArgumentName() {
        return this.name;
    }

    @Override
    public boolean hasParams() {
        return this.params != null;
    }

    @Override
    public void process(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!this.hasParams() && args.length > 1) {
            throw new CommandException("oxygen.command.exception.unnecessaryParams", new Object[]{args[1]});
        }
        if (this.hasParams() && args.length == 1) {
            throw new CommandException("oxygen.command.exception.noParams", new Object[0]);
        }
        if (this.hasParams()) {
            HashMap<String, ArgumentParameter> defParamsMap = new HashMap<String, ArgumentParameter>(this.params.size());
            for (ArgumentParameter param : this.params) {
                defParamsMap.put(param.getParameterName(), param);
            }
            HashSet<ArgumentParameter> paramsSet = new HashSet<ArgumentParameter>(this.params.size());
            String nextArg = null;
            for (int i = 1; i < args.length; ++i) {
                ArgumentParameter param;
                String arg = args[i];
                nextArg = null;
                if (args.length > i + 1) {
                    nextArg = args[i + 1];
                }
                if (!defParamsMap.containsKey(arg)) continue;
                param = (ArgumentParameter)defParamsMap.get(arg);
                if (param.hasValue()) {
                    if (nextArg != null && !defParamsMap.containsKey(nextArg)) {
                        param.setValue(nextArg);
                        paramsSet.add(param);
                        continue;
                    }
                    throw new CommandException("oxygen.command.exception.wrongParamValue", new Object[]{arg, nextArg == null ? "<no value>" : nextArg});
                }
                paramsSet.add(param);
                if (nextArg == null || defParamsMap.containsKey(nextArg)) continue;
                throw new CommandException("oxygen.command.exception.unnecessaryParamValue", new Object[]{arg, nextArg});
            }
            this.execute(server, sender, paramsSet);
        } else {
            this.execute(server, sender, null);
        }
    }

    public static EntityPlayerMP getPlayerByUsername(MinecraftServer server, String username) throws CommandException {
        EntityPlayerMP playerMP = server.func_184103_al().func_152612_a(username);
        if (playerMP != null) {
            return playerMP;
        }
        throw new CommandException("oxygen.command.exception.playerNotFound", new Object[]{username});
    }
}

