/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.concurrent;

import austeretony.oxygen_core.common.main.EnumSide;
import austeretony.oxygen_core.common.main.OxygenMain;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class OxygenExecutors {
    private final EnumSide side;
    private final ExecutorService ioService;
    private final ExecutorService networkService;
    private final ExecutorService routineService;
    private final ScheduledExecutorService schedulerService;
    private final BlockingQueue<Runnable> ioTasksQueue;
    private final BlockingQueue<Runnable> networkTasksQueue;
    private final BlockingQueue<Runnable> routineTasksQueue;

    public OxygenExecutors(EnumSide side, int ioThreads, int networkThreads, int routineThreads, int schedulerThreads) {
        this.side = side;
        String sideStr = side.toString();
        this.ioTasksQueue = new LinkedBlockingQueue<Runnable>();
        this.ioService = new ThreadPoolExecutor(ioThreads, ioThreads, 0L, TimeUnit.MILLISECONDS, this.ioTasksQueue, new ThreadFactoryBuilder().setNameFormat("Oxygen IO #%d " + sideStr).setDaemon(true).build());
        this.networkTasksQueue = new LinkedBlockingQueue<Runnable>();
        this.networkService = new ThreadPoolExecutor(networkThreads, networkThreads, 0L, TimeUnit.MILLISECONDS, this.networkTasksQueue, new ThreadFactoryBuilder().setNameFormat("Oxygen Network #%d " + sideStr).setDaemon(true).build());
        this.routineTasksQueue = new LinkedBlockingQueue<Runnable>();
        this.routineService = new ThreadPoolExecutor(routineThreads, routineThreads, 0L, TimeUnit.MILLISECONDS, this.routineTasksQueue, new ThreadFactoryBuilder().setNameFormat("Oxygen Routine #%d " + sideStr).setDaemon(true).build());
        this.schedulerService = Executors.newScheduledThreadPool(schedulerThreads, new ThreadFactoryBuilder().setNameFormat("Oxygen Scheduler #%d " + sideStr).setDaemon(true).build());
        ((ScheduledThreadPoolExecutor)this.schedulerService).setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }

    public ExecutorService getIOExecutorService() {
        return this.ioService;
    }

    public ExecutorService getNetworkExecutorService() {
        return this.networkService;
    }

    public ExecutorService getRoutineExecutorService() {
        return this.routineService;
    }

    public ScheduledExecutorService getSchedulerExecutorService() {
        return this.schedulerService;
    }

    public BlockingQueue<Runnable> getIOTasksQueue() {
        return this.ioTasksQueue;
    }

    public BlockingQueue<Runnable> getNetworkTasksQueue() {
        return this.networkTasksQueue;
    }

    public BlockingQueue<Runnable> getRoutineTasksQueue() {
        return this.routineTasksQueue;
    }

    public void shutdownServices() {
        OxygenMain.LOGGER.info("Initiated <{}> executors shutdown. Tasks: {}/{}/{}.", (Object)this.side, (Object)this.ioTasksQueue.size(), (Object)this.networkTasksQueue.size(), (Object)this.routineTasksQueue.size());
        this.schedulerService.shutdown();
        this.ioService.shutdown();
        this.networkService.shutdownNow();
        this.routineService.shutdownNow();
        this.awaitSchedulerTasksExecution();
        this.awaitIOTasksExecution();
    }

    private void awaitSchedulerTasksExecution() {
        try {
            boolean executed = this.schedulerService.awaitTermination(10L, TimeUnit.SECONDS);
            if (executed) {
                OxygenMain.LOGGER.info("Successfully executed scheduler tasks at <{}>.", (Object)this.side);
            } else {
                OxygenMain.LOGGER.info("Failed to execute scheduler tasks at <{}>.", (Object)this.side);
            }
        }
        catch (InterruptedException exception) {
            OxygenMain.LOGGER.info("<{}> main thread was interrupteed! Failed to execute scheduler tasks.", (Object)this.side);
        }
    }

    private void awaitIOTasksExecution() {
        try {
            boolean executed = this.ioService.awaitTermination(10L, TimeUnit.SECONDS);
            if (executed) {
                OxygenMain.LOGGER.info("Successfully executed io tasks at <{}>.", (Object)this.side);
            } else {
                OxygenMain.LOGGER.info("Failed to execute io tasks at <{}>.", (Object)this.side);
            }
        }
        catch (InterruptedException exception) {
            OxygenMain.LOGGER.info("<{}> main thread was interrupteed! Failed to execute io tasks.", (Object)this.side);
        }
    }
}

