/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.config;

import austeretony.oxygen_core.common.config.ConfigHolder;
import austeretony.oxygen_core.common.config.ConfigValue;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.client.CPSyncConfigs;
import austeretony.oxygen_core.common.update.UpdateAdaptersManager;
import austeretony.oxygen_core.common.util.JsonUtils;
import austeretony.oxygen_core.server.config.OxygenConfigServer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;

public final class ConfigManager {
    private static ConfigManager instance;
    private final List<ConfigHolder> configs = new ArrayList<ConfigHolder>(10);
    private final ByteBuf compressed = Unpooled.buffer();

    private ConfigManager() {
    }

    public static void create() {
        if (instance == null) {
            instance = new ConfigManager();
        }
    }

    public static ConfigManager instance() {
        return instance;
    }

    public void registerConfig(ConfigHolder config) {
        this.configs.add(config);
    }

    public void loadConfigs() {
        for (ConfigHolder config : this.configs) {
            this.load(config.getExternalPath(), config.getInternalPath(), config);
        }
    }

    public void syncConfigs(EntityPlayerMP playerMP) {
        if (OxygenConfigServer.SYNC_CONFIGS.getBooleanValue() && this.compressed.writerIndex() > 0) {
            OxygenMain.network().sendTo(new CPSyncConfigs(this.compressed), playerMP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfigs(ByteBuf buffer) {
        try {
            for (ConfigHolder configHolder : this.configs) {
                configHolder.read(buffer);
            }
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    private void load(String externalFile, String internalFile, ConfigHolder config) {
        Path configPath = Paths.get(externalFile, new String[0]);
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                this.loadData(ConfigManager.updateConfig(JsonUtils.getInternalJsonData(internalFile).getAsJsonObject(), externalFile, config), config);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("External configuration file for <{}> damaged!", (Object)config.getDomain());
                exception.printStackTrace();
            }
        } else {
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                this.createExternalCopyAndLoad(JsonUtils.getInternalJsonData(internalFile).getAsJsonObject(), externalFile, config);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("Internal configuration file for <{}> damaged!", (Object)config.getDomain());
                exception.printStackTrace();
            }
        }
    }

    private void createExternalCopyAndLoad(JsonObject internalConfig, String externalFile, ConfigHolder configHolder) {
        try {
            JsonUtils.createExternalJsonFile(externalFile, (JsonElement)internalConfig);
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("External config file creation failed for <{}>.", (Object)configHolder.getDomain());
            exception.printStackTrace();
        }
        this.loadData(internalConfig, configHolder);
    }

    private void loadData(JsonObject configFile, ConfigHolder config) {
        OxygenMain.LOGGER.info("Loading config for <{}>...", (Object)config.getDomain());
        config.init(configFile);
        for (ConfigValue value : config.values()) {
            switch (value.getType()) {
                case BOOLEAN: {
                    OxygenMain.LOGGER.info("- {} set to: {}.", (Object)value.getKey(), (Object)value.getBooleanValue());
                    break;
                }
                case INT: {
                    OxygenMain.LOGGER.info("- {} set to: {}.", (Object)value.getKey(), (Object)value.getIntValue());
                    break;
                }
                case LONG: {
                    OxygenMain.LOGGER.info("- {} set to: {}.", (Object)value.getKey(), (Object)value.getLongValue());
                    break;
                }
                case FLOAT: {
                    OxygenMain.LOGGER.info("- {} set to: {}.", (Object)value.getKey(), (Object)Float.valueOf(value.getFloatValue()));
                    break;
                }
                case STRING: {
                    OxygenMain.LOGGER.info("- {} set to: {}.", (Object)value.getKey(), (Object)value.getStringValue());
                }
            }
        }
        if (config.sync()) {
            config.write(this.compressed);
        }
        OxygenMain.LOGGER.info("Config loaded.");
        OxygenMain.LOGGER.info("--------------");
    }

    private static JsonObject updateConfig(JsonObject internalConfig, String externalConfigFolder, ConfigHolder configHolder) throws IOException {
        try {
            JsonObject externalConfigOld = JsonUtils.getExternalJsonData(externalConfigFolder).getAsJsonObject();
            JsonElement versionElement = externalConfigOld.get("version");
            if (versionElement == null || ConfigManager.isOutdated(versionElement.getAsString(), configHolder.getVersion())) {
                OxygenMain.LOGGER.info("Updating <{}> config file...", (Object)configHolder.getDomain());
                JsonObject externalConfigNew = new JsonObject();
                externalConfigNew.add("version", (JsonElement)new JsonPrimitive(configHolder.getVersion()));
                LinkedHashMap internalData = new LinkedHashMap();
                HashMap externlDataOld = new HashMap();
                for (Map.Entry entry : internalConfig.entrySet()) {
                    internalData.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : externalConfigOld.entrySet()) {
                    externlDataOld.put(entry.getKey(), entry.getValue());
                }
                for (String key : internalData.keySet()) {
                    LinkedHashMap internalGroup = new LinkedHashMap();
                    HashMap externlGroupOld = new HashMap();
                    JsonObject externalGroupNew = new JsonObject();
                    for (Map.Entry entry : ((JsonElement)internalData.get(key)).getAsJsonObject().entrySet()) {
                        internalGroup.put(entry.getKey(), entry.getValue());
                    }
                    if (externlDataOld.containsKey(key)) {
                        for (Map.Entry entry : ((JsonElement)externlDataOld.get(key)).getAsJsonObject().entrySet()) {
                            externlGroupOld.put(entry.getKey(), entry.getValue());
                        }
                        for (String k : internalGroup.keySet()) {
                            if (externlGroupOld.containsKey(k)) {
                                externalGroupNew.add(k, (JsonElement)externlGroupOld.get(k));
                                continue;
                            }
                            externalGroupNew.add(k, (JsonElement)internalGroup.get(k));
                        }
                    } else {
                        for (String k : internalGroup.keySet()) {
                            externalGroupNew.add(k, (JsonElement)internalGroup.get(k));
                        }
                    }
                    externalConfigNew.add(key, (JsonElement)externalGroupNew);
                    JsonUtils.createExternalJsonFile(externalConfigFolder, (JsonElement)externalConfigNew);
                }
                if (versionElement != null) {
                    UpdateAdaptersManager.moduleUpdated(configHolder.getDomain(), versionElement.getAsString(), configHolder.getVersion());
                }
                return externalConfigNew;
            }
            return externalConfigOld;
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("External configuration file for <{}> damaged!", (Object)configHolder.getDomain());
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean isOutdated(String currentVersion, String availableVersion) {
        try {
            String[] cSplitted = currentVersion.split("[:]");
            String[] aSplitted = availableVersion.split("[:]");
            String cVer = cSplitted[0];
            String cType = cSplitted[1];
            String cRev = cSplitted[2];
            String aVer = aSplitted[0];
            String aType = aSplitted[1];
            String aRev = aSplitted[2];
            String[] cVerSplitted = cVer.split("[.]");
            String[] aVerSplitted = aVer.split("[.]");
            for (int i = 0; i < 3; ++i) {
                int verDiff = Integer.parseInt(aVerSplitted[i]) - Integer.parseInt(cVerSplitted[i]);
                if (verDiff > 0) {
                    return true;
                }
                if (verDiff >= 0) continue;
                return false;
            }
            if (aType.equals("release") && (cType.equals("beta") || cType.equals("alpha"))) {
                return true;
            }
            if (aType.equals("beta") && cType.equals("alpha")) {
                return true;
            }
            int revDiff = Integer.parseInt(aRev) - Integer.parseInt(cRev);
            if (revDiff > 0) {
                return true;
            }
            if (revDiff < 0) {
                return false;
            }
            return false;
        }
        catch (Exception exception) {
            OxygenMain.LOGGER.error("Versions comparison failed!");
            exception.printStackTrace();
            return true;
        }
    }
}

