/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.core.plugin;

import austeretony.oxygen_core.common.core.plugin.EnumInputClass;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class OxygenClassTransformer
implements IClassTransformer {
    public static final Logger CORE_LOGGER = LogManager.getLogger((String)"Oxygen Core Plugin");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        switch (transformedName) {
            case "net.minecraft.client.gui.GuiPlayerTabOverlay": {
                return this.patch(basicClass, EnumInputClass.MC_GUI_PLAYER_TAB_OVERLAY);
            }
        }
        return basicClass;
    }

    private byte[] patch(byte[] basicClass, EnumInputClass enumInput) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, enumInput.readerFlags);
        if (enumInput.patch(classNode)) {
            CORE_LOGGER.info("{} <{}.class> patched!", (Object)enumInput.domain, (Object)enumInput.clazz);
        } else {
            CORE_LOGGER.info("{} <{}.class> patch SKIPPED!", (Object)enumInput.domain, (Object)enumInput.clazz);
        }
        ClassWriter writer = new ClassWriter(enumInput.writerFlags);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

