/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.inventory;

import austeretony.oxygen_core.common.item.ItemStackWrapper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryHelper {
    public static int getOccupiedSlotsAmount(EntityPlayer player) {
        int occupied = 0;
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (itemStack.func_190926_b()) continue;
            ++occupied;
        }
        return occupied;
    }

    public static boolean haveEnoughSpace(EntityPlayer player, int amount, int maxStackSize) {
        int emptySlots = 0;
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (!itemStack.func_190926_b()) continue;
            ++emptySlots;
        }
        return emptySlots >= amount / maxStackSize;
    }

    public static int getEqualStackAmount(EntityPlayer player, ItemStackWrapper stackWrapper) {
        return InventoryHelper.getEqualStackAmount(player, stackWrapper.itemId, stackWrapper.damage, stackWrapper.stackNBTStr, stackWrapper.capNBTStr);
    }

    public static int getEqualStackAmount(EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound serialized = itemStack.serializeNBT();
        String stackNBT = itemStack.func_77942_o() ? itemStack.func_77978_p().toString() : "";
        String capNBT = serialized.func_74764_b("ForgeCaps") ? serialized.func_74775_l("ForgeCaps").toString() : "";
        return InventoryHelper.getEqualStackAmount(player, Item.func_150891_b((Item)itemStack.func_77973_b()), itemStack.func_77952_i(), stackNBT, capNBT);
    }

    public static int getEqualStackAmount(EntityPlayer player, int itemId, int damage, String stackNBTStr, String capNBTStr) {
        int balance = 0;
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (!InventoryHelper.isEquals(itemStack, itemId, damage, stackNBTStr, capNBTStr)) continue;
            balance += itemStack.func_190916_E();
        }
        return balance;
    }

    public static boolean isEquals(ItemStack itemStack, int itemId, int damage, String stackNBTStr, String capNBTStr) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        NBTTagCompound serialized = itemStack.serializeNBT();
        String stackNBT = itemStack.func_77942_o() ? itemStack.func_77978_p().toString() : "";
        String capNBT = serialized.func_74764_b("ForgeCaps") ? serialized.func_74775_l("ForgeCaps").toString() : "";
        return Item.func_150891_b((Item)itemStack.func_77973_b()) == itemId && itemStack.func_77952_i() == damage && (stackNBTStr.isEmpty() && stackNBT.isEmpty() || stackNBTStr.equals(stackNBT)) && (capNBTStr.isEmpty() && capNBT.isEmpty() || capNBTStr.equals(capNBT));
    }

    public static void addItemStack(EntityPlayer player, ItemStack itemStack, int amount) {
        int maxStack = itemStack.func_77976_d();
        if (amount <= maxStack) {
            ItemStack resultStack = itemStack.func_77946_l();
            resultStack.func_190920_e(amount);
            player.field_71071_by.func_70441_a(resultStack);
        } else {
            ItemStack resultStack;
            int i;
            for (i = amount; i >= maxStack; i -= maxStack) {
                resultStack = itemStack.func_77946_l();
                resultStack.func_190920_e(maxStack);
                player.field_71071_by.func_70441_a(resultStack);
            }
            if (i > 0) {
                resultStack = itemStack.func_77946_l();
                resultStack.func_190920_e(i);
                player.field_71071_by.func_70441_a(resultStack);
            }
        }
    }

    public static void removeEqualStack(EntityPlayer player, ItemStackWrapper stackWrapper, int amount) {
        InventoryHelper.removeEqualStack(player, stackWrapper.itemId, stackWrapper.damage, stackWrapper.stackNBTStr, stackWrapper.capNBTStr, amount);
    }

    public static void removeEqualStack(EntityPlayer player, ItemStack itemStack, int amount) {
        NBTTagCompound serialized = itemStack.serializeNBT();
        String stackNBT = itemStack.func_77942_o() ? itemStack.func_77978_p().toString() : "";
        String capNBT = serialized.func_74764_b("ForgeCaps") ? serialized.func_74775_l("ForgeCaps").toString() : "";
        InventoryHelper.removeEqualStack(player, Item.func_150891_b((Item)itemStack.func_77973_b()), itemStack.func_77952_i(), stackNBT, capNBT, amount);
    }

    public static void removeEqualStack(EntityPlayer player, int itemId, int damage, String stackNBTStr, String capNBTStr, int amount) {
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (!InventoryHelper.isEquals(itemStack, itemId, damage, stackNBTStr, capNBTStr)) continue;
            int stackSize = itemStack.func_190916_E();
            if (stackSize >= amount) {
                itemStack.func_190918_g(amount);
                break;
            }
            amount -= stackSize;
            itemStack.func_190918_g(stackSize);
        }
    }
}

