/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.item;

import austeretony.oxygen_core.common.inventory.InventoryHelper;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.util.StreamUtils;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackWrapper {
    public final String registryName;
    public final String stackNBTStr;
    public final String capNBTStr;
    public final int itemId;
    public final int damage;
    private ItemStack cachedStack;

    private ItemStackWrapper(int itemId, String registryName, int damage, String stackNBTStr, String capNBTStr) {
        this.itemId = itemId;
        this.registryName = registryName;
        this.damage = damage;
        this.stackNBTStr = stackNBTStr;
        this.capNBTStr = capNBTStr;
    }

    public static ItemStackWrapper getFromStack(ItemStack itemStack) {
        NBTTagCompound serialized = itemStack.serializeNBT();
        String stackNBTStr = itemStack.func_77942_o() ? itemStack.func_77978_p().toString() : "";
        String capNBTStr = serialized.func_74764_b("ForgeCaps") ? serialized.func_74775_l("ForgeCaps").toString() : "";
        return new ItemStackWrapper(Item.func_150891_b((Item)itemStack.func_77973_b()), itemStack.func_77973_b().getRegistryName().toString(), itemStack.func_77952_i(), stackNBTStr, capNBTStr);
    }

    public ItemStack getItemStack() {
        NBTTagCompound stackTagCompound = null;
        NBTTagCompound capTagCompound = null;
        Item item = Item.func_150899_d((int)this.itemId);
        if (!this.stackNBTStr.isEmpty()) {
            try {
                stackTagCompound = JsonToNBT.func_180713_a((String)this.stackNBTStr);
            }
            catch (NBTException exception) {
                OxygenMain.LOGGER.error("ItemStack NBT parsing failure! Item: {}", (Object)item.getRegistryName());
                exception.printStackTrace();
            }
        }
        if (!this.capNBTStr.isEmpty()) {
            try {
                capTagCompound = JsonToNBT.func_180713_a((String)this.capNBTStr);
            }
            catch (NBTException exception) {
                OxygenMain.LOGGER.error("ItemStack Forge Capabilities NBT parsing failure! Item: {}", (Object)item.getRegistryName());
                exception.printStackTrace();
            }
        }
        ItemStack itemStack = new ItemStack(item, 1, this.damage, capTagCompound);
        itemStack.func_77982_d(stackTagCompound);
        return itemStack;
    }

    public ItemStack getCachedItemStack() {
        if (this.cachedStack == null) {
            this.cachedStack = this.getItemStack();
        }
        return this.cachedStack;
    }

    public boolean isEquals(ItemStackWrapper other) {
        return this.itemId == other.itemId && this.damage == other.damage && (this.stackNBTStr.isEmpty() && other.stackNBTStr.isEmpty() || this.stackNBTStr.equals(other.stackNBTStr)) && (this.capNBTStr.isEmpty() && other.capNBTStr.isEmpty() || this.capNBTStr.equals(other.capNBTStr));
    }

    public boolean isEquals(ItemStack itemStack) {
        return InventoryHelper.isEquals(itemStack, this.itemId, this.damage, this.stackNBTStr, this.capNBTStr);
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write(this.registryName, (OutputStream)bos);
        StreamUtils.write((short)this.damage, (OutputStream)bos);
        StreamUtils.write(this.stackNBTStr, (OutputStream)bos);
        StreamUtils.write(this.capNBTStr, (OutputStream)bos);
    }

    public static ItemStackWrapper read(BufferedInputStream bis) throws IOException {
        String registryName = StreamUtils.readString(bis);
        return new ItemStackWrapper(Item.func_150891_b((Item)Item.func_111206_d((String)registryName)), registryName, StreamUtils.readShort(bis), StreamUtils.readString(bis), StreamUtils.readString(bis));
    }

    public void write(ByteBuf buffer) {
        buffer.writeShort(this.itemId);
        buffer.writeShort(this.damage);
        ByteBufUtils.writeString(this.stackNBTStr, buffer);
        ByteBufUtils.writeString(this.capNBTStr, buffer);
    }

    public static ItemStackWrapper read(ByteBuf buffer) {
        short itemId = buffer.readShort();
        return new ItemStackWrapper(itemId, Item.func_150899_d((int)itemId).getRegistryName().toString(), buffer.readShort(), ByteBufUtils.readString(buffer), ByteBufUtils.readString(buffer));
    }

    public ItemStackWrapper copy() {
        return new ItemStackWrapper(this.itemId, this.registryName, this.damage, this.stackNBTStr, this.capNBTStr);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.itemId;
        result = 31 * result + this.damage;
        result = 31 * result + this.stackNBTStr.hashCode();
        result = 31 * result + this.capNBTStr.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ItemStackWrapper)) {
            return false;
        }
        ItemStackWrapper other = (ItemStackWrapper)object;
        return this.itemId == other.itemId && this.damage == other.damage && (this.stackNBTStr.isEmpty() && other.stackNBTStr.isEmpty() || this.stackNBTStr.equals(other.stackNBTStr)) && (this.capNBTStr.isEmpty() && other.capNBTStr.isEmpty() || this.capNBTStr.equals(other.capNBTStr));
    }
}

