/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.persistent;

import austeretony.oxygen_core.common.concurrent.OxygenExecutionManager;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.persistent.OxygenIOManager;
import austeretony.oxygen_core.common.persistent.PersistentData;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class PersistentDataManager {
    private final OxygenExecutionManager executionManager;
    private final OxygenIOManager ioManager;
    private final Set<PersistentData> globalData = new HashSet<PersistentData>();

    public PersistentDataManager(OxygenExecutionManager executionManager, OxygenIOManager ioManager) {
        this.executionManager = executionManager;
        this.ioManager = ioManager;
    }

    public void registerPersistentData(PersistentData data) {
        this.globalData.add(data);
        Runnable task = () -> {
            if (data.isChanged()) {
                data.setChanged(false);
                this.ioManager.savePersistentDataAsync(data);
            }
        };
        this.executionManager.getExecutors().getSchedulerExecutorService().scheduleAtFixedRate(task, data.getSaveDelayMinutes(), data.getSaveDelayMinutes(), TimeUnit.MINUTES);
        OxygenMain.LOGGER.info("Registered <{}> persistent data. Scheduled save every <{}> minutes.", (Object)data.getDisplayName(), (Object)data.getSaveDelayMinutes());
    }

    public void worldUnloaded() {
        OxygenMain.LOGGER.info("Forcing persistent data save on world unload...");
        for (PersistentData data : this.globalData) {
            if (!data.isChanged()) continue;
            data.setChanged(false);
            this.ioManager.savePersistentDataAsync(data);
            OxygenMain.LOGGER.info("Persistent data <{}> saved.", (Object)data.getDisplayName());
        }
    }
}

