/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.sound;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class OxygenSoundEffects {
    private static final Map<Integer, SoundEventContainer> REGISTRY = new HashMap<Integer, SoundEventContainer>(10);
    public static final SoundEventContainer INVENTORY = new SoundEventContainer("oxygen_core", "inventory");
    public static final SoundEventContainer SELL = new SoundEventContainer("oxygen_core", "sell");
    public static final SoundEventContainer NOTIFICATION_RECEIVED = new SoundEventContainer("oxygen_core", "request_recieved");
    public static final SoundEventContainer BUTTON_CLICK = new SoundEventContainer("oxygen_core", "button_click");
    public static final SoundEventContainer CONTEXT_OPEN = new SoundEventContainer("oxygen_core", "context_open");
    public static final SoundEventContainer CONTEXT_CLOSE = new SoundEventContainer("oxygen_core", "context_close");
    public static final SoundEventContainer DROP_DOWN_LIST_OPEN = new SoundEventContainer("oxygen_core", "drop_down_list_open");

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{OxygenSoundEffects.INVENTORY.soundEvent, OxygenSoundEffects.SELL.soundEvent, OxygenSoundEffects.NOTIFICATION_RECEIVED.soundEvent, OxygenSoundEffects.BUTTON_CLICK.soundEvent, OxygenSoundEffects.CONTEXT_OPEN.soundEvent, OxygenSoundEffects.CONTEXT_CLOSE.soundEvent, OxygenSoundEffects.DROP_DOWN_LIST_OPEN.soundEvent});
    }

    public static SoundEvent getSoundEvent(int id) {
        return OxygenSoundEffects.REGISTRY.get((Object)Integer.valueOf((int)id)).soundEvent;
    }

    public static class SoundEventContainer {
        public final SoundEvent soundEvent;
        public final int id;
        private static int count;

        public SoundEventContainer(String modId, String name) {
            ResourceLocation location = new ResourceLocation(modId, name);
            this.soundEvent = (SoundEvent)new SoundEvent(location).setRegistryName(location);
            this.id = SoundEventContainer.createId();
            REGISTRY.put(this.id, this);
        }

        public static int createId() {
            return count++;
        }
    }
}

