/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.util;

import austeretony.oxygen_core.common.main.OxygenMain;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class ByteBufUtils {
    public static void writeString(String value, ByteBuf buffer) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        buffer.writeShort(bytes.length);
        buffer.writeBytes(bytes);
    }

    public static String readString(ByteBuf buffer) {
        byte[] bytes = new byte[buffer.readShort()];
        buffer.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static void writeUUID(UUID uuid, ByteBuf buffer) {
        buffer.writeLong(uuid.getMostSignificantBits());
        buffer.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUUID(ByteBuf buffer) {
        return new UUID(buffer.readLong(), buffer.readLong());
    }

    public static void writeItemStack(ItemStack itemStack, ByteBuf buffer) {
        if (itemStack.func_190926_b()) {
            buffer.writeShort(-1);
        } else {
            buffer.writeShort(Item.func_150891_b((Item)itemStack.func_77973_b()));
            buffer.writeByte(itemStack.func_190916_E());
            buffer.writeShort(itemStack.func_77952_i());
            NBTTagCompound tag = itemStack.func_77973_b().getNBTShareTag(itemStack);
            ByteBufUtils.writeString(tag != null ? tag.toString() : "", buffer);
        }
    }

    public static ItemStack readItemStack(ByteBuf buffer) {
        short itemId = buffer.readShort();
        if (itemId < 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = new ItemStack(Item.func_150899_d((int)itemId), (int)buffer.readByte(), (int)buffer.readShort());
        String nbtStr = ByteBufUtils.readString(buffer);
        if (!nbtStr.isEmpty()) {
            try {
                itemStack.func_77973_b().readNBTShareTag(itemStack, JsonToNBT.func_180713_a((String)nbtStr));
            }
            catch (NBTException exception) {
                OxygenMain.LOGGER.error("ItemStack {} NBT parsing failure!", (Object)itemStack.toString());
                exception.printStackTrace();
            }
        }
        return itemStack;
    }
}

