/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.common.util;

import austeretony.oxygen_core.client.api.ClientReference;
import net.minecraft.util.text.TextFormatting;

public class OxygenUtils {
    public static String formattingCode(TextFormatting enumFormatting) {
        return enumFormatting.func_96297_d();
    }

    public static TextFormatting formattingFromCode(String code) {
        return TextFormatting.func_96300_b((String)code);
    }

    public static String formatCurrencyValue(String input) {
        int index = 1;
        StringBuilder builder = new StringBuilder();
        for (char c : new StringBuilder(input).reverse().toString().toCharArray()) {
            builder.append(c);
            if (index % 3 == 0 && index != input.length()) {
                builder.append(",");
            }
            ++index;
        }
        return builder.reverse().toString();
    }

    public static String getTimePassedLocalizedString(long timeStampMillis) {
        if (timeStampMillis > 0L) {
            long delta = System.currentTimeMillis() - timeStampMillis;
            long hours = delta / 3600000L;
            if (hours < 24L) {
                if (hours % 10L == 1L) {
                    return ClientReference.localize("oxygen.gui.hour", hours);
                }
                if (hours < 1L) {
                    long minutes = delta / 60000L;
                    if (minutes % 10L == 1L) {
                        return ClientReference.localize("oxygen.gui.minute", minutes);
                    }
                    return ClientReference.localize("oxygen.gui.minutes", minutes);
                }
                return ClientReference.localize("oxygen.gui.hours", hours);
            }
            long days = hours / 24L;
            if (days % 10L == 1L) {
                return ClientReference.localize("oxygen.gui.day", days);
            }
            return ClientReference.localize("oxygen.gui.days", days);
        }
        return ClientReference.localize("oxygen.gui.undef", new Object[0]);
    }

    public static String getExpirationTimeLocalizedString(long expiresInMillis, long timeStampMillis) {
        if (timeStampMillis > 0L) {
            long expiresInMinutes = expiresInMillis / 60000L;
            long deltaPassed = System.currentTimeMillis() - timeStampMillis;
            long minutesPassed = deltaPassed / 60000L;
            long expirationTimeMinutes = expiresInMinutes - minutesPassed;
            if (expirationTimeMinutes < 0L) {
                return ClientReference.localize("oxygen.gui.expired", new Object[0]);
            }
            if (expirationTimeMinutes < 60L) {
                if (expirationTimeMinutes % 10L == 1L) {
                    return ClientReference.localize("oxygen.gui.minute", expirationTimeMinutes);
                }
                return ClientReference.localize("oxygen.gui.minutes", expirationTimeMinutes);
            }
            expirationTimeMinutes = (expiresInMinutes /= 60L) - (minutesPassed /= 60L);
            if (expirationTimeMinutes < 24L) {
                if (expirationTimeMinutes % 10L == 1L) {
                    return ClientReference.localize("oxygen.gui.hour", expirationTimeMinutes);
                }
                return ClientReference.localize("oxygen.gui.hours", expirationTimeMinutes);
            }
            long expirationTimeDays = expirationTimeMinutes / 24L;
            if (expirationTimeDays % 10L == 1L) {
                return ClientReference.localize("oxygen.gui.day", expirationTimeDays);
            }
            return ClientReference.localize("oxygen.gui.days", expirationTimeDays);
        }
        return ClientReference.localize("oxygen.gui.undef", new Object[0]);
    }
}

