/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.EnumOxygenPrivilege;
import austeretony.oxygen_core.common.main.EnumOxygenStatusMessage;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.client.CPSyncNotification;
import austeretony.oxygen_core.common.notification.EnumNotification;
import austeretony.oxygen_core.common.notification.EnumRequestReply;
import austeretony.oxygen_core.common.notification.Notification;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.OxygenPlayerData;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegeProviderServer;
import austeretony.oxygen_core.server.api.event.OxygenPlayerLoadedEvent;
import austeretony.oxygen_core.server.api.event.OxygenPlayerUnloadedEvent;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PlayerDataManagerServer {
    private final OxygenManagerServer manager;

    public PlayerDataManagerServer(OxygenManagerServer manager) {
        this.manager = manager;
    }

    public void informPlayer(EntityPlayerMP playerMP, EnumOxygenStatusMessage status) {
        OxygenHelperServer.sendStatusMessage(playerMP, 0, status.ordinal());
    }

    public void playerLoggedIn(EntityPlayerMP playerMP) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (!this.manager.getPlayerDataContainer().isPlayerDataExist(playerUUID)) {
            OxygenPlayerData playerData = this.manager.getPlayerDataContainer().createPlayerData(playerUUID);
            OxygenHelperServer.loadPersistentData(playerData);
            this.manager.getSharedDataManager().createSharedDataEntry(playerMP);
            this.manager.getWatcherManager().initWatcher((EntityPlayer)playerMP, playerUUID);
            CommonReference.delegateToServerThread(() -> MinecraftForge.EVENT_BUS.post((Event)new OxygenPlayerLoadedEvent(playerMP)));
        }
    }

    public void playerLoggedOut(EntityPlayerMP playerMP) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (this.manager.getPlayerDataContainer().isPlayerDataExist(playerUUID)) {
            MinecraftForge.EVENT_BUS.post((Event)new OxygenPlayerUnloadedEvent(playerMP));
            this.manager.getSharedDataManager().removeSharedDataEntry(playerUUID);
            this.manager.getPlayerDataContainer().removePlayerData(playerUUID);
        }
    }

    public void addNotification(EntityPlayerMP playerMP, Notification notification) {
        if (notification.getType() == EnumNotification.REQUEST) {
            this.manager.getPlayerDataContainer().getPlayerData(CommonReference.getPersistentUUID((Entity)playerMP)).addTemporaryProcess(notification);
        }
        OxygenMain.network().sendTo(new CPSyncNotification(notification), playerMP);
    }

    public void sendRequest(EntityPlayerMP sender, EntityPlayerMP target, Notification notification) {
        UUID senderUUID = CommonReference.getPersistentUUID((Entity)sender);
        UUID targetUUID = CommonReference.getPersistentUUID((Entity)target);
        OxygenPlayerData senderData = this.manager.getPlayerDataContainer().getPlayerData(senderUUID);
        OxygenPlayerData targetData = this.manager.getPlayerDataContainer().getPlayerData(targetUUID);
        if ((targetData.getActivityStatus() != OxygenPlayerData.EnumActivityStatus.OFFLINE || PrivilegeProviderServer.getValue(senderUUID, EnumOxygenPrivilege.EXPOSE_PLAYERS_OFFLINE.toString(), false)) && this.manager.getRequestsManager().validateRequest(senderUUID, targetUUID)) {
            this.addNotification(target, notification);
            this.informPlayer(sender, EnumOxygenStatusMessage.REQUEST_SENT);
        } else {
            this.informPlayer(sender, EnumOxygenStatusMessage.REQUEST_RESET);
        }
    }

    public void processRequestReply(EntityPlayer player, EnumRequestReply reply, long id) {
        this.manager.getPlayerDataContainer().getPlayerData(CommonReference.getPersistentUUID((Entity)player)).processRequestReply(player, reply, id);
    }

    public void changeActivityStatus(EntityPlayerMP playerMP, OxygenPlayerData.EnumActivityStatus status) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        OxygenPlayerData playerData = this.manager.getPlayerDataContainer().getPlayerData(playerUUID);
        if (status != playerData.getActivityStatus()) {
            playerData.setActivityStatus(status);
            playerData.setChanged(true);
            this.manager.getSharedDataManager().updateActivityStatus(playerMP, status);
        }
    }

    protected void processRequests() {
        OxygenHelperServer.addRoutineTask(() -> {
            for (OxygenPlayerData profile : this.manager.getPlayerDataContainer().getPlayersData()) {
                profile.runTemporaryProcesses();
            }
        });
    }
}

