/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ServerDataContainer {
    public String worldFolder;
    public int maxPlayers;
    private String dataFolder;
    private long worldId;

    public String getDataFolder() {
        return this.dataFolder;
    }

    public long getWorldId() {
        return this.worldId;
    }

    public void createOrLoadWorldId(String worldFolder, int maxPlayers) {
        this.worldFolder = worldFolder;
        this.maxPlayers = maxPlayers;
        this.createOrLoadWorldId();
    }

    private void createOrLoadWorldId() {
        String worldIdFilePathStr = this.worldFolder + "/oxygen/worldid.txt";
        Path worldIdPath = Paths.get(worldIdFilePathStr, new String[0]);
        if (Files.exists(worldIdPath, new LinkOption[0])) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(worldIdFilePathStr));){
                String worldIdStr = bufferedReader.readLine();
                this.worldId = Long.parseLong(worldIdStr);
                OxygenMain.LOGGER.info("Loaded world id: {}.", (Object)worldIdStr);
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("World id loading failed.");
                exception.printStackTrace();
            }
        } else {
            this.worldId = Long.parseLong(new SimpleDateFormat("yyMMddHHmmss").format(new Date()));
            String worldIdStr = String.valueOf(this.worldId);
            OxygenMain.LOGGER.info("Created world id: {}.", (Object)worldIdStr);
            try {
                Files.createDirectories(worldIdPath.getParent(), new FileAttribute[0]);
                try (PrintStream printStream = new PrintStream(new File(worldIdFilePathStr));){
                    printStream.println(worldIdStr);
                }
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("World id saving failed.");
                exception.printStackTrace();
            }
        }
        this.dataFolder = CommonReference.getGameFolder() + "/oxygen/worlds/" + this.worldId;
    }
}

