/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.command.privilege;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.command.AbstractOxygenCommand;
import austeretony.oxygen_core.common.command.ArgumentExecutor;
import austeretony.oxygen_core.common.privilege.PrivilegedGroup;
import austeretony.oxygen_core.server.api.PrivilegeProviderServer;
import austeretony.oxygen_core.server.command.privilege.GroupArgumentExecutor;
import austeretony.oxygen_core.server.command.privilege.InfoArgumentExecutor;
import austeretony.oxygen_core.server.command.privilege.PrivilegeArgumentExecutor;
import austeretony.oxygen_core.server.command.privilege.PromoteArgumentExecutor;
import java.util.Set;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;

public class CommandPrivilege
extends AbstractOxygenCommand {
    public static final String ACTION_GROUP_INFO = "group-info";
    public static final String ACTION_GROUP_PRIVILEGES = "group-privileges";
    public static final String ACTION_PLAYERS_LIST = "players-list";
    public static final String ACTION_GROUPS_LIST = "groups-list";
    public static final String ACTION_PLAYER_GROUP = "player-group";
    public static final String ACTION_CREATE = "create";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_REMOVE = "remove";
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_ADD = "add";
    public static final String PARAMETER_VALUE = "value";
    public static final String PARAMETER_PRIVILEGE = "privilege";
    public static final String PARAMETER_GROUP = "group";
    public static final String PARAMETER_PLAYER = "player";
    public static final String PARAMETER_PREFIX = "prefix";
    public static final String PARAMETER_SUFFIX = "suffix";
    public static final String PARAMETER_USERNAME_COLOR = "username-color";
    public static final String PARAMETER_PREFIX_COLOR = "prefix-color";
    public static final String PARAMETER_SUFFIX_COLOR = "suffix-color";
    public static final String PARAMETER_CHAT_COLOR = "chat-color";

    public CommandPrivilege(String commandName) {
        super(commandName);
    }

    @Override
    public void getArgumentExecutors(Set<ArgumentExecutor> executors) {
        executors.add(new InfoArgumentExecutor("info", true));
        executors.add(new GroupArgumentExecutor(PARAMETER_GROUP, true));
        executors.add(new PrivilegeArgumentExecutor(PARAMETER_PRIVILEGE, true));
        executors.add(new PromoteArgumentExecutor("promote", true));
    }

    @Override
    public boolean valid(MinecraftServer server, ICommandSender sender) {
        return sender instanceof MinecraftServer || sender instanceof EntityPlayer && CommonReference.isPlayerOpped((EntityPlayer)sender);
    }

    public static PrivilegedGroup getPrivilegedGroupByName(String groupName) throws CommandException {
        PrivilegedGroup group = PrivilegeProviderServer.getGroup(groupName);
        if (group != null) {
            return group;
        }
        throw new CommandException("oxygen.command.exception.groupNotFound", new Object[]{groupName});
    }
}

