/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.command.privilege;

import austeretony.oxygen_core.common.api.command.AbstractArgumentExecutor;
import austeretony.oxygen_core.common.api.command.ArgumentParameterImpl;
import austeretony.oxygen_core.common.command.ArgumentParameter;
import austeretony.oxygen_core.common.main.EnumOxygenChatMessage;
import austeretony.oxygen_core.common.privilege.PrivilegedGroupImpl;
import austeretony.oxygen_core.common.util.OxygenUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegeProviderServer;
import austeretony.oxygen_core.server.command.privilege.CommandPrivilege;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class GroupArgumentExecutor
extends AbstractArgumentExecutor {
    public GroupArgumentExecutor(String argument, boolean hasParams) {
        super(argument, hasParams);
    }

    @Override
    public void getParams(Set<ArgumentParameter> params) {
        params.add(new ArgumentParameterImpl("create"));
        params.add(new ArgumentParameterImpl("edit"));
        params.add(new ArgumentParameterImpl("remove"));
        params.add(new ArgumentParameterImpl("group", true));
        params.add(new ArgumentParameterImpl("prefix", true));
        params.add(new ArgumentParameterImpl("suffix", true));
        params.add(new ArgumentParameterImpl("username-color", true));
        params.add(new ArgumentParameterImpl("prefix-color", true));
        params.add(new ArgumentParameterImpl("suffix-color", true));
        params.add(new ArgumentParameterImpl("chat-color", true));
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, Set<ArgumentParameter> params) throws CommandException {
        Enum action = null;
        String groupName = null;
        String prefix = null;
        String suffix = null;
        String nameColor = null;
        String prefixColor = null;
        String suffixColor = null;
        String chatColor = null;
        for (ArgumentParameter param : params) {
            if (param.getBaseName().equals("create")) {
                action = EnumAction.CREATE;
                continue;
            }
            if (param.getBaseName().equals("edit")) {
                action = EnumAction.EDIT;
                continue;
            }
            if (param.getBaseName().equals("remove")) {
                action = EnumAction.REMOVE;
                continue;
            }
            if (param.getBaseName().equals("group")) {
                groupName = param.getValue();
                continue;
            }
            if (param.getBaseName().equals("prefix")) {
                prefix = param.getValue();
                continue;
            }
            if (param.getBaseName().equals("suffix")) {
                suffix = param.getValue();
                continue;
            }
            if (param.getBaseName().equals("username-color")) {
                nameColor = param.getValue();
                continue;
            }
            if (param.getBaseName().equals("prefix-color")) {
                prefixColor = param.getValue();
                continue;
            }
            if (param.getBaseName().equals("suffix-color")) {
                suffixColor = param.getValue();
                continue;
            }
            if (!param.getBaseName().equals("chat-color")) continue;
            chatColor = param.getValue();
        }
        if (action != null && groupName != null) {
            switch (1.$SwitchMap$austeretony$oxygen_core$server$command$privilege$GroupArgumentExecutor$EnumAction[action.ordinal()]) {
                case 1: {
                    TextFormatting color;
                    PrivilegedGroupImpl group = new PrivilegedGroupImpl(groupName);
                    if (prefix != null) {
                        group.setPrefix(prefix);
                    }
                    if (suffix != null) {
                        group.setSuffix(suffix);
                    }
                    if (nameColor != null) {
                        color = OxygenUtils.formattingFromCode(nameColor);
                        group.setUsernameColor(color == null ? TextFormatting.WHITE : color);
                    }
                    if (prefixColor != null) {
                        color = OxygenUtils.formattingFromCode(prefixColor);
                        group.setPrefixColor(color == null ? TextFormatting.WHITE : color);
                    }
                    if (suffixColor != null) {
                        color = OxygenUtils.formattingFromCode(suffixColor);
                        group.setSuffixColor(color == null ? TextFormatting.WHITE : color);
                    }
                    if (chatColor != null) {
                        color = OxygenUtils.formattingFromCode(chatColor);
                        group.setChatColor(color == null ? TextFormatting.WHITE : color);
                    }
                    PrivilegeProviderServer.addGroup(group, true);
                    if (sender instanceof EntityPlayerMP) {
                        OxygenHelperServer.sendChatMessage(CommandBase.func_71521_c((ICommandSender)sender), 0, EnumOxygenChatMessage.COMMAND_PRIVILEGE_GROUP_CREATE.ordinal(), groupName);
                        OxygenHelperServer.sendChatMessage(CommandBase.func_71521_c((ICommandSender)sender), 0, EnumOxygenChatMessage.COMMAND_PRIVILEGE_INFO_GROUP_INFO.ordinal(), groupName, group.getPrefix(), group.getSuffix(), OxygenUtils.formattingCode(group.getUsernameColor()), OxygenUtils.formattingCode(group.getPrefixColor()), OxygenUtils.formattingCode(group.getSuffixColor()), OxygenUtils.formattingCode(group.getChatColor()));
                        break;
                    }
                    server.func_145747_a((ITextComponent)new TextComponentString(String.format("Created group <%s>.", groupName)));
                    server.func_145747_a((ITextComponent)new TextComponentString(String.format("Group: %s - prefix %s, suffix: %s, username color: %s, prefix color: %s, suffix color: %s, chat color: %s.", groupName, group.getPrefix(), group.getSuffix(), OxygenUtils.formattingCode(group.getUsernameColor()), OxygenUtils.formattingCode(group.getPrefixColor()), OxygenUtils.formattingCode(group.getSuffixColor()), OxygenUtils.formattingCode(group.getChatColor()))));
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    PrivilegeProviderServer.removeGroup(CommandPrivilege.getPrivilegedGroupByName(groupName).getName());
                    if (sender instanceof EntityPlayerMP) {
                        OxygenHelperServer.sendChatMessage(CommandBase.func_71521_c((ICommandSender)sender), 0, EnumOxygenChatMessage.COMMAND_PRIVILEGE_GROUP_REMOVE.ordinal(), groupName);
                        break;
                    }
                    server.func_145747_a((ITextComponent)new TextComponentString(String.format("Removed group <%s>.", groupName)));
                }
            }
        }
    }

    public static enum EnumAction {
        CREATE,
        EDIT,
        REMOVE;

    }
}

