/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.command.privilege;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.command.AbstractArgumentExecutor;
import austeretony.oxygen_core.common.api.command.ArgumentParameterImpl;
import austeretony.oxygen_core.common.command.ArgumentParameter;
import austeretony.oxygen_core.common.main.EnumOxygenChatMessage;
import austeretony.oxygen_core.common.privilege.Privilege;
import austeretony.oxygen_core.common.privilege.PrivilegedGroup;
import austeretony.oxygen_core.common.util.OxygenUtils;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegeProviderServer;
import austeretony.oxygen_core.server.command.privilege.CommandPrivilege;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InfoArgumentExecutor
extends AbstractArgumentExecutor {
    public InfoArgumentExecutor(String argument, boolean hasParams) {
        super(argument, hasParams);
    }

    @Override
    public void getParams(Set<ArgumentParameter> params) {
        params.add(new ArgumentParameterImpl("group-info"));
        params.add(new ArgumentParameterImpl("group-privileges"));
        params.add(new ArgumentParameterImpl("groups-list"));
        params.add(new ArgumentParameterImpl("player-group"));
        params.add(new ArgumentParameterImpl("group", true));
        params.add(new ArgumentParameterImpl("player", true));
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, Set<ArgumentParameter> params) throws CommandException {
        Enum type = null;
        String groupName = null;
        String playerName = null;
        for (ArgumentParameter param : params) {
            if (param.getBaseName().equals("group-info")) {
                type = EnumType.GROUP_INFO;
                continue;
            }
            if (param.getBaseName().equals("group-privileges")) {
                type = EnumType.GROUP_PRIVILEGES;
                continue;
            }
            if (param.getBaseName().equals("groups-list")) {
                type = EnumType.GROUPS_LIST;
                continue;
            }
            if (param.getBaseName().equals("player-group")) {
                type = EnumType.PLAYER_GROUP;
                continue;
            }
            if (param.getBaseName().equals("group")) {
                groupName = param.getValue();
                continue;
            }
            if (!param.getBaseName().equals("player")) continue;
            playerName = param.getValue();
        }
        if (type != null) {
            switch (1.$SwitchMap$austeretony$oxygen_core$server$command$privilege$InfoArgumentExecutor$EnumType[type.ordinal()]) {
                case 1: {
                    if (groupName == null) break;
                    PrivilegedGroup group = CommandPrivilege.getPrivilegedGroupByName(groupName);
                    if (sender instanceof EntityPlayerMP) {
                        OxygenHelperServer.sendChatMessage(CommandBase.func_71521_c((ICommandSender)sender), 0, EnumOxygenChatMessage.COMMAND_PRIVILEGE_INFO_GROUP_INFO.ordinal(), groupName, group.getPrefix(), group.getSuffix(), OxygenUtils.formattingCode(group.getUsernameColor()), OxygenUtils.formattingCode(group.getSuffixColor()), OxygenUtils.formattingCode(group.getPrefixColor()), OxygenUtils.formattingCode(group.getChatColor()));
                        break;
                    }
                    server.func_145747_a((ITextComponent)new TextComponentString(String.format("Group: %s - prefix %s, suffix: %s, username color: %s, prefix color: %s, suffix color: %s, chat color: %s.", groupName, group.getPrefix(), group.getSuffix(), OxygenUtils.formattingCode(group.getUsernameColor()), OxygenUtils.formattingCode(group.getSuffixColor()), OxygenUtils.formattingCode(group.getPrefixColor()), OxygenUtils.formattingCode(group.getChatColor()))));
                    break;
                }
                case 2: {
                    Object playerMP;
                    if (groupName == null) break;
                    PrivilegedGroup group = CommandPrivilege.getPrivilegedGroupByName(groupName);
                    if (sender instanceof EntityPlayerMP) {
                        playerMP = (EntityPlayerMP)sender;
                        OxygenHelperServer.sendChatMessage((EntityPlayerMP)playerMP, 0, EnumOxygenChatMessage.COMMAND_PRIVILEGE_INFO_GROUP_PRIVILEGES.ordinal(), groupName);
                        for (Privilege privilege : group.getPrivileges()) {
                            OxygenHelperServer.sendChatMessage((EntityPlayerMP)playerMP, 0, EnumOxygenChatMessage.SIMPLE_LINE.ordinal(), privilege.getName());
                        }
                    } else {
                        server.func_145747_a((ITextComponent)new TextComponentString(String.format("Group <%s> privileges:", groupName)));
                        for (Privilege privilege : group.getPrivileges()) {
                            server.func_145747_a((ITextComponent)new TextComponentString(privilege.getName()));
                        }
                    }
                    break;
                }
                case 3: {
                    if (sender instanceof EntityPlayerMP) {
                        EntityPlayerMP playerMP = (EntityPlayerMP)sender;
                        OxygenHelperServer.sendChatMessage(playerMP, 0, EnumOxygenChatMessage.COMMAND_PRIVILEGE_INFO_GROUPS_LIST.ordinal(), new String[0]);
                        for (PrivilegedGroup group : OxygenManagerServer.instance().getPrivilegesManager().getGroups().values()) {
                            OxygenHelperServer.sendChatMessage(playerMP, 0, EnumOxygenChatMessage.SIMPLE_LINE.ordinal(), group.getName());
                        }
                    } else {
                        server.func_145747_a((ITextComponent)new TextComponentString("Groups:"));
                        for (PrivilegedGroup group : OxygenManagerServer.instance().getPrivilegesManager().getGroups().values()) {
                            server.func_145747_a((ITextComponent)new TextComponentString(group.getName()));
                        }
                    }
                    break;
                }
                case 4: {
                    Object playerMP;
                    if (playerName == null) break;
                    EntityPlayerMP targetMP = InfoArgumentExecutor.getPlayerByUsername(server, playerName);
                    if (sender instanceof EntityPlayerMP) {
                        playerMP = (EntityPlayerMP)sender;
                        OxygenHelperServer.sendChatMessage((EntityPlayerMP)playerMP, 0, EnumOxygenChatMessage.COMMAND_PRIVILEGE_INFO_PLAYER_GROUP.ordinal(), playerName, PrivilegeProviderServer.getPlayerGroup(CommonReference.getPersistentUUID((Entity)targetMP)).getName());
                        break;
                    }
                    server.func_145747_a((ITextComponent)new TextComponentString(String.format("Player %s group: %s.", playerName, PrivilegeProviderServer.getPlayerGroup(CommonReference.getPersistentUUID((Entity)targetMP)).getName())));
                    break;
                }
            }
        }
    }

    public static enum EnumType {
        GROUP_INFO,
        GROUP_PRIVILEGES,
        GROUPS_LIST,
        PLAYER_GROUP;

    }
}

