/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.command.privilege;

import austeretony.oxygen_core.common.EnumValueType;
import austeretony.oxygen_core.common.api.command.AbstractArgumentExecutor;
import austeretony.oxygen_core.common.api.command.ArgumentParameterImpl;
import austeretony.oxygen_core.common.command.ArgumentParameter;
import austeretony.oxygen_core.common.main.EnumOxygenChatMessage;
import austeretony.oxygen_core.common.privilege.PrivilegeImpl;
import austeretony.oxygen_core.common.privilege.PrivilegeRegistry;
import austeretony.oxygen_core.common.privilege.PrivilegedGroup;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.command.privilege.CommandPrivilege;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class PrivilegeArgumentExecutor
extends AbstractArgumentExecutor {
    public PrivilegeArgumentExecutor(String argument, boolean hasParams) {
        super(argument, hasParams);
    }

    @Override
    public void getParams(Set<ArgumentParameter> params) {
        params.add(new ArgumentParameterImpl("add"));
        params.add(new ArgumentParameterImpl("remove"));
        params.add(new ArgumentParameterImpl("save"));
        params.add(new ArgumentParameterImpl("group", true));
        params.add(new ArgumentParameterImpl("privilege", true));
        params.add(new ArgumentParameterImpl("value", true));
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, Set<ArgumentParameter> params) throws CommandException {
        Enum action = null;
        String groupName = null;
        String privilegeName = null;
        String valueStr = null;
        boolean save = false;
        for (ArgumentParameter param : params) {
            if (param.getBaseName().equals("add")) {
                action = EnumAction.ADD;
                continue;
            }
            if (param.getBaseName().equals("remove")) {
                action = EnumAction.REMOVE;
                continue;
            }
            if (param.getBaseName().equals("save")) {
                save = true;
                continue;
            }
            if (param.getBaseName().equals("group")) {
                groupName = param.getValue();
                continue;
            }
            if (param.getBaseName().equals("privilege")) {
                privilegeName = param.getValue();
                continue;
            }
            if (!param.getBaseName().equals("value")) continue;
            valueStr = param.getValue();
        }
        if (action != null && groupName != null) {
            PrivilegedGroup group = CommandPrivilege.getPrivilegedGroupByName(groupName);
            switch (1.$SwitchMap$austeretony$oxygen_core$server$command$privilege$PrivilegeArgumentExecutor$EnumAction[action.ordinal()]) {
                case 1: {
                    if (!PrivilegeRegistry.privilegeExist(privilegeName)) {
                        throw new CommandException("oxygen.command.exception.privilegeNotFound", new Object[]{privilegeName});
                    }
                    if (valueStr == null) {
                        throw new CommandException("oxygen.command.exception.wrongParamValue", new Object[]{"-value", "empty"});
                    }
                    PrivilegeImpl privilege = null;
                    EnumValueType type = PrivilegeRegistry.getRegistryEntry(privilegeName).type;
                    switch (type) {
                        case BOOLEAN: {
                            privilege = new PrivilegeImpl(privilegeName, Boolean.parseBoolean(valueStr));
                            break;
                        }
                        case INT: {
                            int intValue = 0;
                            try {
                                intValue = Integer.parseInt(valueStr);
                            }
                            catch (NumberFormatException exception) {
                                throw new CommandException("oxygen.command.exception.wrongParamValue", new Object[]{"-value", valueStr});
                            }
                            privilege = new PrivilegeImpl(privilegeName, intValue);
                            break;
                        }
                        case LONG: {
                            long longValue = 0L;
                            try {
                                longValue = Long.parseLong(valueStr);
                            }
                            catch (NumberFormatException exception) {
                                throw new CommandException("oxygen.command.exception.wrongParamValue", new Object[]{"-value", valueStr});
                            }
                            privilege = new PrivilegeImpl(privilegeName, longValue);
                            break;
                        }
                        case FLOAT: {
                            float floatValue = 0.0f;
                            try {
                                floatValue = Float.parseFloat(valueStr);
                            }
                            catch (NumberFormatException exception) {
                                throw new CommandException("oxygen.command.exception.wrongParamValue", new Object[]{"-value", valueStr});
                            }
                            privilege = new PrivilegeImpl(privilegeName, floatValue);
                            break;
                        }
                        case STRING: {
                            privilege = new PrivilegeImpl(privilegeName, valueStr);
                        }
                    }
                    group.addPrivilege(privilege, save);
                    if (sender instanceof EntityPlayerMP) {
                        OxygenHelperServer.sendChatMessage(CommandBase.func_71521_c((ICommandSender)sender), 0, EnumOxygenChatMessage.COMMAND_PRIVILEGE_PRIVILEGE_ADD.ordinal(), privilegeName, valueStr, groupName);
                        break;
                    }
                    server.func_145747_a((ITextComponent)new TextComponentString(String.format("Added privilege <%s> with value <%s> to group <%s>.", privilegeName, valueStr, groupName)));
                    break;
                }
                case 2: {
                    group.removePrivilege(privilegeName, save);
                    if (sender instanceof EntityPlayerMP) {
                        OxygenHelperServer.sendChatMessage(CommandBase.func_71521_c((ICommandSender)sender), 0, EnumOxygenChatMessage.COMMAND_PRIVILEGE_PRIVILEGE_REMOVE.ordinal(), privilegeName, groupName);
                        break;
                    }
                    server.func_145747_a((ITextComponent)new TextComponentString(String.format("Removed privilege <%s> from group <%s>.", privilegeName, groupName)));
                }
            }
        }
    }

    public static enum EnumAction {
        ADD,
        REMOVE;

    }
}

