/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.command.privilege;

import austeretony.oxygen_core.common.api.command.AbstractArgumentExecutor;
import austeretony.oxygen_core.common.api.command.ArgumentParameterImpl;
import austeretony.oxygen_core.common.command.ArgumentParameter;
import austeretony.oxygen_core.common.main.EnumOxygenChatMessage;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegeProviderServer;
import austeretony.oxygen_core.server.command.privilege.CommandPrivilege;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class PromoteArgumentExecutor
extends AbstractArgumentExecutor {
    public PromoteArgumentExecutor(String argument, boolean hasParams) {
        super(argument, hasParams);
    }

    @Override
    public void getParams(Set<ArgumentParameter> params) {
        params.add(new ArgumentParameterImpl("group", true));
        params.add(new ArgumentParameterImpl("player", true));
    }

    @Override
    public void execute(MinecraftServer server, ICommandSender sender, Set<ArgumentParameter> params) throws CommandException {
        String groupName = null;
        String playerName = null;
        for (ArgumentParameter param : params) {
            if (param.getBaseName().equals("group")) {
                groupName = param.getValue();
                continue;
            }
            if (!param.getBaseName().equals("player")) continue;
            playerName = param.getValue();
        }
        if (groupName != null && playerName != null) {
            EntityPlayerMP playerMP = PromoteArgumentExecutor.getPlayerByUsername(server, playerName);
            PrivilegeProviderServer.promotePlayer((EntityPlayer)playerMP, CommandPrivilege.getPrivilegedGroupByName(groupName).getName());
            if (sender instanceof EntityPlayerMP) {
                OxygenHelperServer.sendChatMessage(CommandBase.func_71521_c((ICommandSender)sender), 0, EnumOxygenChatMessage.COMMAND_PRIVILEGE_PROMOTE.ordinal(), playerName, groupName);
            } else {
                server.func_145747_a((ITextComponent)new TextComponentString(String.format("Player <%s> promoted to group <%s>.", playerName, groupName)));
            }
        }
    }
}

