/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.privilege;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.privilege.EnumPrivilegeFileKey;
import austeretony.oxygen_core.common.privilege.PrivilegedGroup;
import austeretony.oxygen_core.common.privilege.PrivilegedGroupImpl;
import austeretony.oxygen_core.common.util.JsonUtils;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.event.OxygenPrivilegesLoadedEvent;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PrivilegesLoaderServer {
    public static void loadPrivilegeData() {
        PrivilegesLoaderServer.loadPrivilegedGroups();
        PrivilegesLoaderServer.loadPlayersList();
        OxygenManagerServer.instance().getPrivilegesManager().addDefaultGroups();
        CommonReference.delegateToServerThread(() -> MinecraftForge.EVENT_BUS.post((Event)new OxygenPrivilegesLoadedEvent()));
    }

    private static void loadPlayersList() {
        String folder = OxygenHelperServer.getDataFolder() + "/server/privileges/players.json";
        Path path = Paths.get(folder, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                JsonArray jsonArray = JsonUtils.getExternalJsonData(folder).getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    JsonObject object = element.getAsJsonObject();
                    UUID playerUUID = UUID.fromString(object.get(EnumPrivilegeFileKey.PLAYER_UUID.name).getAsString());
                    OxygenManagerServer.instance().getPrivilegesManager().promotePlayer(playerUUID, object.get(EnumPrivilegeFileKey.GROUP.name).getAsString());
                }
                OxygenMain.LOGGER.info("Loaded privileged players list.");
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("Privileged players list loading failed.");
                exception.printStackTrace();
            }
        }
    }

    private static void loadPrivilegedGroups() {
        String folder = OxygenHelperServer.getDataFolder() + "/server/privileges/groups.json";
        Path path = Paths.get(folder, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                JsonArray groupArray = JsonUtils.getExternalJsonData(folder).getAsJsonArray();
                for (JsonElement groupElement : groupArray) {
                    OxygenManagerServer.instance().getPrivilegesManager().addGroup(PrivilegedGroupImpl.deserializeServer(groupElement.getAsJsonObject()), false);
                }
                OxygenMain.LOGGER.info("Privileged groups loaded.");
            }
            catch (IOException exception) {
                OxygenMain.LOGGER.error("Privileged groups loading failed.");
                exception.printStackTrace();
            }
        }
    }

    public static void savePlayersListAsync() {
        OxygenHelperServer.addIOTask(() -> PrivilegesLoaderServer.savePlayersList());
    }

    public static void savePlayersList() {
        String folder = OxygenHelperServer.getDataFolder() + "/server/privileges/players.json";
        Path path = Paths.get(folder, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        try {
            JsonArray jsonArray = new JsonArray();
            for (Map.Entry<UUID, String> entry : OxygenManagerServer.instance().getPrivilegesManager().getPlayers().entrySet()) {
                JsonObject object = new JsonObject();
                object.add(EnumPrivilegeFileKey.PLAYER_UUID.name, (JsonElement)new JsonPrimitive(entry.getKey().toString()));
                object.add(EnumPrivilegeFileKey.GROUP.name, (JsonElement)new JsonPrimitive(entry.getValue()));
                jsonArray.add((JsonElement)object);
            }
            JsonUtils.createExternalJsonFile(folder, (JsonElement)jsonArray);
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("Privileged players list saving failed.");
            exception.printStackTrace();
        }
    }

    public static void savePrivilegedGroupsAsync() {
        OxygenHelperServer.addIOTask(() -> PrivilegesLoaderServer.savePrivilegedGroups());
    }

    public static void savePrivilegedGroups() {
        String folder = OxygenHelperServer.getDataFolder() + "/server/privileges/groups.json";
        Path path = Paths.get(folder, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        try {
            JsonArray jsonArray = new JsonArray();
            for (PrivilegedGroup group : OxygenManagerServer.instance().getPrivilegesManager().getGroups().values()) {
                jsonArray.add((JsonElement)group.serialize());
            }
            JsonUtils.createExternalJsonFile(folder, (JsonElement)jsonArray);
        }
        catch (IOException exception) {
            OxygenMain.LOGGER.error("Privileged groups saving failed.");
            exception.printStackTrace();
        }
    }
}

