/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_core.server.sync;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.client.CPSyncDataFragment;
import austeretony.oxygen_core.common.network.client.CPSyncValidDataIds;
import austeretony.oxygen_core.common.sync.DataFragment;
import austeretony.oxygen_core.server.api.RequestsFilterHelper;
import austeretony.oxygen_core.server.sync.DataSyncHandlerServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class DataSyncManagerServer {
    private final Map<Integer, DataSyncHandlerServer> handlers = new HashMap<Integer, DataSyncHandlerServer>(5);

    public void registerHandler(DataSyncHandlerServer handler) {
        this.handlers.put(handler.getDataId(), handler);
        RequestsFilterHelper.registerNetworkRequest(handler.getDataId() + 100, 2);
        RequestsFilterHelper.registerNetworkRequest(handler.getDataId() + 200, 2);
    }

    public void syncData(EntityPlayerMP playerMP, int dataId) {
        if (this.handlers.containsKey(dataId)) {
            UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
            DataSyncHandlerServer handler = this.getHandler(dataId);
            if (!handler.allowSync(playerUUID)) {
                return;
            }
            Set<Long> idsSet = handler.getIds(playerUUID);
            long[] ids = new long[idsSet.size()];
            int index = 0;
            for (long id : idsSet) {
                ids[index++] = id;
            }
            OxygenMain.network().sendTo(new CPSyncValidDataIds(dataId, ids), playerMP);
        }
    }

    public DataSyncHandlerServer getHandler(int dataId) {
        return this.handlers.get(dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncAbsentData(EntityPlayerMP playerMP, int dataId, long[] ids) {
        if (this.handlers.containsKey(dataId)) {
            UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
            ByteBuf buffer = null;
            try {
                byte[] rawEntries;
                DataSyncHandlerServer handler = this.getHandler(dataId);
                buffer = Unpooled.buffer((int)16383);
                int maxPayload = 32703;
                int entriesCount = 0;
                int prevWriterIndex = 0;
                ArrayList<DataFragment> fragments = new ArrayList<DataFragment>(3);
                for (long id : ids) {
                    Object entry = handler.getEntry(playerUUID, id);
                    if (entry == null) continue;
                    prevWriterIndex = buffer.writerIndex();
                    entry.write(buffer);
                    ++entriesCount;
                    if (buffer.writerIndex() <= maxPayload) continue;
                    buffer.writerIndex(prevWriterIndex);
                    rawEntries = new byte[prevWriterIndex];
                    buffer.readBytes(rawEntries);
                    fragments.add(new DataFragment(entriesCount - 1, rawEntries));
                    buffer.clear();
                    entriesCount = 0;
                    prevWriterIndex = buffer.writerIndex();
                    entry.write(buffer);
                    ++entriesCount;
                }
                rawEntries = new byte[buffer.writerIndex()];
                buffer.readBytes(rawEntries);
                fragments.add(new DataFragment(entriesCount, rawEntries));
                Object object = fragments.iterator();
                while (object.hasNext()) {
                    DataFragment fragment = (DataFragment)object.next();
                    OxygenMain.network().sendTo(new CPSyncDataFragment(dataId, fragments.size(), fragment.entriesAmount, fragment.rawData), playerMP);
                }
            }
            finally {
                if (buffer != null) {
                    buffer.release();
                }
            }
        }
    }
}

