/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.justmobheads.util;

import akka.japi.Pair;
import com.natamus.justmobheads.util.HeadData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MobHeads {
    static List<String> ocelottypes = Arrays.asList("", "black", "ginger", "siamese");
    static List<String> horsetypes = Arrays.asList("white", "creamy", "chestnut", "brown", "black", "gray", "dark_brown");
    static List<String> llamatypes = Arrays.asList("creamy", "white", "brown", "gray");
    static List<String> parrottypes = Arrays.asList("red", "blue", "green", "cyan", "gray");
    static List<String> rabbittypes = Arrays.asList("brown", "white", "black", "black_and_white", "gold", "salt_and_pepper");
    static List<String> villagertypes = Arrays.asList("farmer", "librarian", "priest", "blacksmith", "butcher", "nitwit");

    public static ItemStack getMobHead(String mobname) {
        Pair<String, String> mobdata = HeadData.headdata.get(mobname.replace(" ", "_").toLowerCase());
        ItemStack mobhead = new ItemStack(Items.field_151144_bL, 1, 3);
        NBTTagCompound skullOwner = new NBTTagCompound();
        skullOwner.func_74778_a("Id", (String)mobdata.first());
        NBTTagCompound properties = new NBTTagCompound();
        NBTTagList textures = new NBTTagList();
        NBTTagCompound tex = new NBTTagCompound();
        tex.func_74778_a("Value", (String)mobdata.second());
        textures.func_74742_a((NBTBase)tex);
        properties.func_74782_a("textures", (NBTBase)textures);
        skullOwner.func_74782_a("Properties", (NBTBase)properties);
        mobhead.func_77983_a("SkullOwner", (NBTBase)skullOwner);
        mobhead.func_151001_c(MobHeads.capitalizeFirst(mobname.replace("_", " ")) + " Head");
        return mobhead;
    }

    public static ItemStack getStandardHead(String headname) {
        String mob = headname.toLowerCase().split(" ")[0];
        Integer meta = 3;
        if (mob.equals("creeper")) {
            meta = 4;
        } else if (mob.equals("zombie")) {
            meta = 2;
        } else if (mob.equals("skeleton")) {
            meta = 0;
        }
        ItemStack mobhead = new ItemStack(Items.field_151144_bL, 1, meta.intValue());
        mobhead.func_151001_c(headname);
        return mobhead;
    }

    public static String getName(Entity entity, Boolean dropchance) {
        String mobname = entity.toString().split("\\[")[0].replace("Entity", "");
        mobname = String.join((CharSequence)"_", mobname.split("(?<=.)(?=\\p{Lu})")).toLowerCase();
        if (entity instanceof EntityCreeper) {
            EntityCreeper creeper = (EntityCreeper)entity;
            if (creeper.func_70830_n()) {
                mobname = "charged_creeper";
            }
        } else {
            EntityZombieVillager zombievillager;
            Integer type;
            if (dropchance.booleanValue()) {
                return mobname;
            }
            if (entity instanceof EntityOcelot) {
                EntityOcelot ocelot = (EntityOcelot)entity;
                Integer type2 = ocelot.func_70913_u();
                if (type2 > 0 && type2 < ocelottypes.size()) {
                    mobname = ocelottypes.get(type2) + "_cat";
                }
            } else if (entity instanceof EntityHorse) {
                EntityHorse horse = (EntityHorse)entity;
                Integer type3 = horse.func_110202_bQ();
                if (type3 >= 1024) {
                    type3 = type3 - 1024;
                } else if (type3 >= 768) {
                    type3 = type3 - 768;
                } else if (type3 >= 512) {
                    type3 = type3 - 512;
                } else if (type3 >= 256) {
                    type3 = type3 - 256;
                }
                mobname = horsetypes.get(type3) + "_horse";
            } else if (entity instanceof EntityLlama) {
                EntityLlama llama = (EntityLlama)entity;
                Integer type4 = llama.func_190719_dM();
                mobname = llamatypes.get(type4) + "_llama";
            } else if (entity instanceof EntityParrot) {
                EntityParrot parrot = (EntityParrot)entity;
                Integer type5 = parrot.func_191998_ds();
                mobname = parrottypes.get(type5) + "_parrot";
            } else if (entity instanceof EntityRabbit) {
                EntityRabbit rabbit = (EntityRabbit)entity;
                Integer type6 = rabbit.func_175531_cl();
                if (type6 < rabbittypes.size()) {
                    mobname = rabbittypes.get(type6) + "_rabbit";
                } else if (type6 == 99) {
                    mobname = "killer_rabbit";
                }
            } else if (entity instanceof EntitySheep) {
                EntitySheep sheep = (EntitySheep)entity;
                EnumDyeColor type7 = sheep.func_175509_cj();
                mobname = type7.toString().toLowerCase() + "_sheep";
            } else if (entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)entity;
                Integer type8 = villager.func_70946_n();
                if (type8 < villagertypes.size()) {
                    mobname = villagertypes.get(type8);
                }
            } else if (entity instanceof EntityZombieVillager && (type = Integer.valueOf((zombievillager = (EntityZombieVillager)entity).func_190736_dl())) < villagertypes.size()) {
                mobname = "zombie_" + villagertypes.get(type);
            }
        }
        return mobname;
    }

    public static String capitalizeFirst(String string) {
        StringBuffer sb = new StringBuffer(string);
        for (int i = 0; i < sb.length(); ++i) {
            if (i != 0 && sb.charAt(i - 1) != ' ') continue;
            sb.setCharAt(i, Character.toUpperCase(sb.charAt(i)));
        }
        return sb.toString();
    }
}

