/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.generation;

import buildcraft.core.BCCoreBlocks;
import buildcraft.energy.BCEnergyConfig;
import buildcraft.energy.generation.OilGenStructure;
import buildcraft.lib.misc.RandUtil;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.Box;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeEnd;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OilGenerator {
    private static final long MAGIC_GEN_NUMBER = -3438862373895731249L;
    private static final int MAX_CHUNK_RADIUS = 5;

    private OilGenerator() {
    }

    @SubscribeEvent
    public static void onPopulatePre(PopulateChunkEvent.Pre event) {
        World world = event.getWorld();
        int chunkX = event.getChunkX();
        int chunkZ = event.getChunkZ();
        if (world.func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        boolean isExcludedDimension = BCEnergyConfig.excludedDimensions.contains(world.field_73011_w.getDimension());
        if (isExcludedDimension == BCEnergyConfig.excludedDimensionsIsBlackList) {
            return;
        }
        world.field_72984_F.func_76320_a("bc_oil");
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        BlockPos min = new BlockPos(x, 0, z);
        Box box = new Box(min, min.func_177982_a(15, world.func_72800_K(), 15));
        for (int cdx = -5; cdx <= 5; ++cdx) {
            for (int cdz = -5; cdz <= 5; ++cdz) {
                int cx = chunkX + cdx;
                int cz = chunkZ + cdz;
                world.field_72984_F.func_76320_a("scan");
                List<OilGenStructure> structures = OilGenerator.getStructures(world, cx, cz);
                OilGenStructure.Spring spring = null;
                world.field_72984_F.func_76318_c("gen");
                for (OilGenStructure struct : structures) {
                    struct.generate(world, box);
                    if (!(struct instanceof OilGenStructure.Spring)) continue;
                    spring = (OilGenStructure.Spring)struct;
                }
                if (spring != null && box.contains(spring.pos)) {
                    int count = 0;
                    for (OilGenStructure struct : structures) {
                        count += struct.countOilBlocks();
                    }
                    spring.generate(world, count);
                }
                world.field_72984_F.func_76319_b();
            }
        }
        world.field_72984_F.func_76319_b();
    }

    public static List<OilGenStructure> getStructures(World world, int cx, int cz) {
        int tendrilRadius;
        int lakeRadius;
        GenType type;
        int z;
        Random rand = RandUtil.createRandomForChunk((World)world, (int)cx, (int)cz, (long)-3438862373895731249L);
        int x = cx * 16 + 8 + rand.nextInt(16);
        Biome biome = world.func_180494_b(new BlockPos(x, 0, z = cz * 16 + 8 + rand.nextInt(16)));
        boolean isExcludedBiome = BCEnergyConfig.excludedBiomes.contains(biome.getRegistryName());
        if (isExcludedBiome == BCEnergyConfig.excludedBiomesIsBlackList) {
            return ImmutableList.of();
        }
        if (biome instanceof BiomeEnd && (Math.abs(x) < 1200 || Math.abs(z) < 1200)) {
            return ImmutableList.of();
        }
        boolean oilBiome = BCEnergyConfig.surfaceDepositBiomes.contains(biome.getRegistryName());
        double bonus = oilBiome ? 3.0 : 1.0;
        bonus *= BCEnergyConfig.oilWellGenerationRate;
        if (BCEnergyConfig.excessiveBiomes.contains(biome.getRegistryName())) {
            bonus *= 30.0;
        }
        if (rand.nextDouble() <= BCEnergyConfig.largeOilGenProb * bonus) {
            type = GenType.LARGE;
        } else if (rand.nextDouble() <= BCEnergyConfig.mediumOilGenProb * bonus) {
            type = GenType.MEDIUM;
        } else if (oilBiome && rand.nextDouble() <= BCEnergyConfig.smallOilGenProb * bonus) {
            type = GenType.LAKE;
        } else {
            return ImmutableList.of();
        }
        ArrayList<OilGenStructure> structures = new ArrayList<OilGenStructure>();
        if (type == GenType.LARGE) {
            lakeRadius = 4;
            tendrilRadius = 25 + rand.nextInt(20);
        } else if (type == GenType.LAKE) {
            lakeRadius = 6;
            tendrilRadius = 25 + rand.nextInt(20);
        } else {
            lakeRadius = 2;
            tendrilRadius = 5 + rand.nextInt(10);
        }
        structures.add(OilGenerator.createTendril(new BlockPos(x, 62, z), lakeRadius, tendrilRadius, rand));
        if (type != GenType.LAKE) {
            int wellY = 20 + rand.nextInt(10);
            int radius = type == GenType.LARGE ? 8 + rand.nextInt(9) : 4 + rand.nextInt(4);
            structures.add(OilGenerator.createSphere(new BlockPos(x, wellY, z), radius));
            if (BCEnergyConfig.enableOilSpouts) {
                int height;
                int maxHeight;
                int minHeight;
                if (type == GenType.LARGE) {
                    minHeight = BCEnergyConfig.largeSpoutMinHeight;
                    maxHeight = BCEnergyConfig.largeSpoutMaxHeight;
                    radius = 1;
                } else {
                    minHeight = BCEnergyConfig.smallSpoutMinHeight;
                    maxHeight = BCEnergyConfig.smallSpoutMaxHeight;
                    radius = 0;
                }
                if (maxHeight == minHeight) {
                    height = maxHeight;
                } else {
                    if (maxHeight < minHeight) {
                        int t = maxHeight;
                        maxHeight = minHeight;
                        minHeight = t;
                    }
                    height = minHeight + rand.nextInt(maxHeight - minHeight);
                }
                structures.add(OilGenerator.createSpout(new BlockPos(x, wellY, z), height, radius));
            }
            if (type == GenType.LARGE) {
                structures.add(OilGenerator.createTube(new BlockPos(x, 1, z), wellY, radius, EnumFacing.Axis.Y));
                if (BCCoreBlocks.spring != null) {
                    structures.add(OilGenerator.createSpring(new BlockPos(x, 0, z)));
                }
            }
        }
        return structures;
    }

    private static OilGenStructure createSpout(BlockPos start, int height, int radius) {
        return new OilGenStructure.Spout(start, OilGenStructure.ReplaceType.ALWAYS, radius, height);
    }

    public static OilGenStructure createTubeY(BlockPos base, int height, int radius) {
        return OilGenerator.createTube(base, height, radius, EnumFacing.Axis.Y);
    }

    public static OilGenStructure createSpring(BlockPos at) {
        return new OilGenStructure.Spring(at);
    }

    public static OilGenStructure createTube(BlockPos center, int length, int radius, EnumFacing.Axis axis) {
        int valForAxis = VecUtil.getValue((Vec3i)center, (EnumFacing.Axis)axis);
        BlockPos min = VecUtil.replaceValue((Vec3i)center.func_177982_a(-radius, -radius, -radius), (EnumFacing.Axis)axis, (int)valForAxis);
        BlockPos max = VecUtil.replaceValue((Vec3i)center.func_177982_a(radius, radius, radius), (EnumFacing.Axis)axis, (int)(valForAxis + length));
        double radiusSq = radius * radius;
        int toReplace = valForAxis;
        Predicate<BlockPos> tester = p -> VecUtil.replaceValue((Vec3i)p, (EnumFacing.Axis)axis, (int)toReplace).func_177951_i((Vec3i)center) <= radiusSq;
        return new OilGenStructure.GenByPredicate(new Box(min, max), OilGenStructure.ReplaceType.ALWAYS, tester);
    }

    public static OilGenStructure createSphere(BlockPos center, int radius) {
        Box box = new Box(center.func_177982_a(-radius, -radius, -radius), center.func_177982_a(radius, radius, radius));
        double radiusSq = (double)(radius * radius) + 0.01;
        Predicate<BlockPos> tester = p -> p.func_177951_i((Vec3i)center) <= radiusSq;
        return new OilGenStructure.GenByPredicate(box, OilGenStructure.ReplaceType.ALWAYS, tester);
    }

    public static OilGenStructure createTendril(BlockPos center, int lakeRadius, int radius, Random rand) {
        BlockPos start = center.func_177982_a(-radius, 0, -radius);
        int diameter = radius * 2 + 1;
        boolean[][] pattern = new boolean[diameter][diameter];
        int x = radius;
        int z = radius;
        for (int dx = -lakeRadius; dx <= lakeRadius; ++dx) {
            for (int dz = -lakeRadius; dz <= lakeRadius; ++dz) {
                pattern[x + dx][z + dz] = dx * dx + dz * dz <= lakeRadius * lakeRadius;
            }
        }
        for (int w = 1; w < radius; ++w) {
            float proba = (float)(radius - w + 4) / (float)(radius + 4);
            OilGenerator.fillPatternIfProba(rand, proba, x, z + w, pattern);
            OilGenerator.fillPatternIfProba(rand, proba, x, z - w, pattern);
            OilGenerator.fillPatternIfProba(rand, proba, x + w, z, pattern);
            OilGenerator.fillPatternIfProba(rand, proba, x - w, z, pattern);
            for (int i = 1; i <= w; ++i) {
                OilGenerator.fillPatternIfProba(rand, proba, x + i, z + w, pattern);
                OilGenerator.fillPatternIfProba(rand, proba, x + i, z - w, pattern);
                OilGenerator.fillPatternIfProba(rand, proba, x + w, z + i, pattern);
                OilGenerator.fillPatternIfProba(rand, proba, x - w, z + i, pattern);
                OilGenerator.fillPatternIfProba(rand, proba, x - i, z + w, pattern);
                OilGenerator.fillPatternIfProba(rand, proba, x - i, z - w, pattern);
                OilGenerator.fillPatternIfProba(rand, proba, x + w, z - i, pattern);
                OilGenerator.fillPatternIfProba(rand, proba, x - w, z - i, pattern);
            }
        }
        int depth = rand.nextDouble() < 0.5 ? 1 : 2;
        return OilGenStructure.PatternTerrainHeight.create(start, OilGenStructure.ReplaceType.IS_FOR_LAKE, pattern, depth);
    }

    private static void fillPatternIfProba(Random rand, float proba, int x, int z, boolean[][] pattern) {
        if (rand.nextFloat() <= proba) {
            pattern[x][z] = OilGenerator.isSet(pattern, x, z - 1) | OilGenerator.isSet(pattern, x, z + 1) | OilGenerator.isSet(pattern, x - 1, z) | OilGenerator.isSet(pattern, x + 1, z);
        }
    }

    private static boolean isSet(boolean[][] pattern, int x, int z) {
        if (x < 0 || x >= pattern.length) {
            return false;
        }
        if (z < 0 || z >= pattern[x].length) {
            return false;
        }
        return pattern[x][z];
    }

    private static enum GenType {
        LARGE,
        MEDIUM,
        LAKE,
        NONE;

    }
}

