/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IFluidFilter;
import buildcraft.api.core.IFluidHandlerAdv;
import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.fuels.IFuelManager;
import buildcraft.api.fuels.ISolidCoolant;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.transport.pipe.IItemPipe;
import buildcraft.energy.BCEnergyGuis;
import buildcraft.lib.engine.EngineConnector;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.fluid.Tank;
import buildcraft.lib.fluid.TankProperties;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.EntityUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.net.PacketBufferBC;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TileEngineIron_BC8
extends TileEngineBase_BC8 {
    public static final int MAX_FLUID = 10000;
    public static final double COOLDOWN_RATE = 0.05;
    public static final int MAX_COOLANT_PER_TICK = 40;
    public final Tank tankFuel = new Tank("fuel", 10000, (TileEntity)this, this::isValidFuel);
    public final Tank tankCoolant = new Tank("coolant", 10000, (TileEntity)this, this::isValidCoolant){

        protected Tank.FluidGetResult map(ItemStack stack, int space) {
            ISolidCoolant coolant = BuildcraftFuelRegistry.coolant.getSolidCoolant(stack);
            if (coolant == null) {
                return super.map(stack, space);
            }
            FluidStack fluidCoolant = coolant.getFluidFromSolidCoolant(stack);
            if (fluidCoolant == null || fluidCoolant.amount <= 0 || fluidCoolant.amount > space) {
                return super.map(stack, space);
            }
            return new Tank.FluidGetResult(StackUtil.EMPTY, fluidCoolant);
        }
    };
    public final Tank tankResidue = new Tank("residue", 10000, (TileEntity)this, this::isResidue);
    private final IFluidHandlerAdv fluidHandler = new InternalFluidHandler();
    private int penaltyCooling = 0;
    private boolean lastPowered = false;
    private double burnTime;
    private double residueAmount = 0.0;
    private IFuel currentFuel;

    public TileEngineIron_BC8() {
        this.tankManager.addAll(new Tank[]{this.tankFuel, this.tankCoolant, this.tankResidue});
        this.tankFuel.helpInfo = new ElementHelpInfo(this.tankFuel.helpInfo.title, -52429, new String[]{"buildcraft.help.tank.generic", null, "buildcraft.help.tank.fuel"});
        this.tankCoolant.helpInfo = new ElementHelpInfo(this.tankCoolant.helpInfo.title, -11184641, new String[]{"buildcraft.help.tank.generic", null, "buildcraft.help.tank.coolant"});
        this.tankResidue.helpInfo = new ElementHelpInfo(this.tankResidue.helpInfo.title, -5622870, new String[]{"buildcraft.help.tank.generic", null, "buildcraft.help.tank.residue"});
        this.caps.addCapabilityInstance(CapUtil.CAP_FLUIDS, (Object)this.fluidHandler, EnumPipePart.VALUES);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("penaltyCooling", this.penaltyCooling);
        nbt.func_74780_a("burnTime", this.burnTime);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.penaltyCooling = nbt.func_74762_e("penaltyCooling");
        this.burnTime = nbt.func_74769_h("burnTime");
    }

    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && (id == NET_GUI_DATA || id == NET_GUI_TICK)) {
            this.tankManager.readData(buffer);
        }
    }

    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && (id == NET_GUI_DATA || id == NET_GUI_TICK)) {
            this.tankManager.writeData(buffer);
        }
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack current = player.func_184586_b(hand).func_77946_l();
        if (super.onActivated(player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!current.func_190926_b()) {
            if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null) {
                return false;
            }
            if (current.func_77973_b() instanceof IItemPipe) {
                return false;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            BCEnergyGuis.ENGINE_IRON.openGUI(player, this.func_174877_v());
        }
        return true;
    }

    public double getPistonSpeed() {
        switch (this.getPowerStage()) {
            case BLUE: {
                return 0.04;
            }
            case GREEN: {
                return 0.05;
            }
            case YELLOW: {
                return 0.06;
            }
            case RED: {
                return 0.07;
            }
        }
        return 0.0;
    }

    @Nonnull
    protected IMjConnector createConnector() {
        return new EngineConnector(false);
    }

    public boolean isBurning() {
        FluidStack fuel = this.tankFuel.getFluid();
        return fuel != null && fuel.amount > 0 && this.penaltyCooling == 0 && this.isRedstonePowered;
    }

    protected void burn() {
        FluidStack fuel = this.tankFuel.getFluid();
        if (this.currentFuel == null || !this.currentFuel.getFluid().isFluidEqual(fuel)) {
            this.currentFuel = BuildcraftFuelRegistry.fuel.getFuel(fuel);
        }
        if (fuel == null || this.currentFuel == null) {
            return;
        }
        if (this.penaltyCooling <= 0) {
            if (this.isRedstonePowered) {
                this.lastPowered = true;
                if (this.burnTime > 0.0 || fuel.amount > 0) {
                    if (this.burnTime > 0.0) {
                        this.burnTime -= 1.0;
                    }
                    if (this.burnTime <= 0.0) {
                        if (fuel.amount > 0) {
                            --fuel.amount;
                            this.burnTime += (double)this.currentFuel.getTotalBurningTime() / 1000.0;
                            if (this.currentFuel instanceof IFuelManager.IDirtyFuel) {
                                IFuelManager.IDirtyFuel dirtyFuel = (IFuelManager.IDirtyFuel)this.currentFuel;
                                FluidStack residueFluid = dirtyFuel.getResidue().copy();
                                this.residueAmount += (double)residueFluid.amount / 1000.0;
                                if (this.residueAmount >= 1.0) {
                                    residueFluid.amount = MathHelper.func_76128_c((double)this.residueAmount);
                                    this.residueAmount -= (double)this.tankResidue.fill(residueFluid, true);
                                } else if (this.tankResidue.getFluid() == null) {
                                    residueFluid.amount = 0;
                                    this.tankResidue.setFluid(residueFluid);
                                }
                            }
                        } else {
                            this.tankFuel.setFluid(null);
                            this.currentFuel = null;
                            this.currentOutput = 0L;
                            return;
                        }
                    }
                    this.currentOutput = this.currentFuel.getPowerPerCycle();
                    this.addPower(this.currentFuel.getPowerPerCycle());
                    this.heat += (double)this.currentFuel.getPowerPerCycle() * 0.0023 / (double)MjAPI.MJ;
                }
            } else if (this.lastPowered) {
                this.lastPowered = false;
                this.penaltyCooling = 10;
            }
        }
        if (this.burnTime <= 0.0 && fuel.amount <= 0) {
            this.tankFuel.setFluid(null);
        }
    }

    public void updateHeatLevel() {
        double target;
        if (this.heat > 20.0 && (this.penaltyCooling > 0 || !this.isRedstonePowered)) {
            this.heat -= 0.05;
            target = 20.0;
        } else {
            target = this.heat > 100.0 ? 100.0 : this.heat;
        }
        if (target != this.heat) {
            float coolPerMb;
            double coolingBuffer = 0.0;
            double extraHeat = this.heat - target;
            if (extraHeat > 0.0 && this.tankCoolant.getFluidAmount() > 0 && (coolPerMb = BuildcraftFuelRegistry.coolant.getDegreesPerMb(this.tankCoolant.getFluid(), (float)this.heat)) > 0.0f) {
                int coolantAmount = Math.min(40, this.tankCoolant.getFluidAmount());
                float cooling = coolPerMb;
                coolingBuffer += (double)((float)coolantAmount * cooling);
                this.tankCoolant.drain(coolantAmount, true);
            }
            this.heat -= coolingBuffer;
            double d = 0.0;
            this.getPowerStage();
        }
        if (this.heat <= 20.0 && this.penaltyCooling > 0) {
            --this.penaltyCooling;
        }
        if (this.heat <= 20.0) {
            this.heat = 20.0;
        }
    }

    public boolean isActive() {
        return this.penaltyCooling <= 0;
    }

    public long getMaxPower() {
        return 10000L * MjAPI.MJ;
    }

    public long maxPowerReceived() {
        return 2000L * MjAPI.MJ;
    }

    public long maxPowerExtracted() {
        return 500L * MjAPI.MJ;
    }

    public float explosionRange() {
        return 4.0f;
    }

    public long getCurrentOutput() {
        if (this.currentFuel == null) {
            return 0L;
        }
        return this.currentFuel.getPowerPerCycle();
    }

    private boolean isValidFuel(FluidStack fluid) {
        return BuildcraftFuelRegistry.fuel.getFuel(fluid) != null;
    }

    private boolean isValidCoolant(FluidStack fluid) {
        return BuildcraftFuelRegistry.coolant.getCoolant(fluid) != null;
    }

    private boolean isResidue(FluidStack fluid) {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return true;
        }
        if (this.currentFuel instanceof IFuelManager.IDirtyFuel) {
            return fluid.isFluidEqual(((IFuelManager.IDirtyFuel)this.currentFuel).getResidue());
        }
        return false;
    }

    private class InternalFluidHandler
    implements IFluidHandlerAdv {
        private final IFluidTankProperties[] properties;

        private InternalFluidHandler() {
            this.properties = new IFluidTankProperties[]{new TankProperties(TileEngineIron_BC8.this.tankFuel, true, false), new TankProperties(TileEngineIron_BC8.this.tankCoolant, true, false), new TankProperties(TileEngineIron_BC8.this.tankResidue, false, true)};
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.properties;
        }

        public int fill(FluidStack resource, boolean doFill) {
            int filled = TileEngineIron_BC8.this.tankFuel.fill(resource, doFill);
            if (filled == 0) {
                filled = TileEngineIron_BC8.this.tankCoolant.fill(resource, doFill);
            }
            return filled;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return TileEngineIron_BC8.this.tankResidue.drain(resource, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            return TileEngineIron_BC8.this.tankResidue.drain(maxDrain, doDrain);
        }

        public FluidStack drain(IFluidFilter filter, int maxDrain, boolean doDrain) {
            return TileEngineIron_BC8.this.tankResidue.drain(filter, maxDrain, doDrain);
        }
    }
}

