/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.proxy;

import com.github.lunatrius.core.handler.ConfigurationHandler;
import com.github.lunatrius.core.reference.Reference;
import com.github.lunatrius.core.version.VersionChecker;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public abstract class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        Reference.logger = event.getModLog();
        FMLInterModComms.sendMessage((String)"lunatriuscore", (String)"checkUpdate", (String)"14.23.0.2512");
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (VersionChecker.isAllowedToCheck("Global") && ConfigurationHandler.VersionCheck.checkForUpdates) {
            VersionChecker.startVersionCheck();
        }
    }

    public void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (!"checkUpdate".equals(message.key) || !message.isStringMessage()) continue;
            this.processMessage(message.getSender(), message.getStringValue());
        }
    }

    private void processMessage(String sender, String forgeVersion) {
        ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(sender);
        if (container != null) {
            VersionChecker.registerMod(container, forgeVersion);
        }
    }
}

