/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_trade.client.PlayerOfferClient;
import austeretony.oxygen_trade.common.config.TradeConfig;
import austeretony.oxygen_trade.common.main.TradeMain;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OffersContainerClient
extends AbstractPersistentData {
    private final Map<Long, PlayerOfferClient> offers = new ConcurrentHashMap<Long, PlayerOfferClient>();

    public int getOffersAmount() {
        return this.offers.size();
    }

    public Set<Long> getOfferIds() {
        return this.offers.keySet();
    }

    public Collection<PlayerOfferClient> getOffers() {
        return this.offers.values();
    }

    public PlayerOfferClient getOffer(long offerId) {
        return this.offers.get(offerId);
    }

    public void addOffer(PlayerOfferClient offer) {
        this.offers.put(offer.getId(), offer);
    }

    public void removeOffer(long offerId) {
        this.offers.remove(offerId);
    }

    public String getDisplayName() {
        return "offers_data";
    }

    public String getPath() {
        return OxygenHelperClient.getDataFolder() + "/client/world/trade/offers_client.dat";
    }

    public long getSaveDelayMinutes() {
        return TradeConfig.DATA_SAVE_DELAY_MINUTES.getIntValue();
    }

    public void read(BufferedInputStream bis) throws IOException {
        int amount = StreamUtils.readInt((InputStream)bis);
        for (int i = 0; i < amount; ++i) {
            PlayerOfferClient offer = new PlayerOfferClient();
            offer.read(bis);
            this.addOffer(offer);
        }
        TradeMain.LOGGER.info("Loaded <{}> trade offers.", (Object)this.getOffersAmount());
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((int)this.offers.size(), (OutputStream)bos);
        for (PlayerOfferClient offer : this.offers.values()) {
            offer.write(bos);
        }
    }

    public void reset() {
        this.offers.clear();
    }
}

