/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_trade.client.SalesHistoryEntryClient;
import austeretony.oxygen_trade.common.config.TradeConfig;
import austeretony.oxygen_trade.common.main.TradeMain;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SalesHistoryContainerClient
extends AbstractPersistentData {
    private final Map<Long, SalesHistoryEntryClient> history = new ConcurrentHashMap<Long, SalesHistoryEntryClient>();

    public int getEntriesAmount() {
        return this.history.size();
    }

    public Set<Long> getEntriesIds() {
        return this.history.keySet();
    }

    public Collection<SalesHistoryEntryClient> getEntries() {
        return this.history.values();
    }

    public boolean isEntryExist(long entryId) {
        return this.history.containsKey(entryId);
    }

    public SalesHistoryEntryClient getEntry(long entryId) {
        return this.history.get(entryId);
    }

    public void addEntry(SalesHistoryEntryClient entry) {
        this.history.put(entry.getId(), entry);
    }

    public void removeEntry(long entryId) {
        this.history.remove(entryId);
    }

    public String getDisplayName() {
        return "sales_history";
    }

    public String getPath() {
        return OxygenHelperClient.getDataFolder() + "/client/world/trade/sales_history.dat";
    }

    public long getSaveDelayMinutes() {
        return TradeConfig.DATA_SAVE_DELAY_MINUTES.getIntValue();
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((int)this.history.size(), (OutputStream)bos);
        for (SalesHistoryEntryClient offer : this.history.values()) {
            offer.write(bos);
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        int amount = StreamUtils.readInt((InputStream)bis);
        for (int i = 0; i < amount; ++i) {
            SalesHistoryEntryClient entry = new SalesHistoryEntryClient();
            entry.read(bis);
            this.addEntry(entry);
        }
        TradeMain.LOGGER.info("Loaded <{}> sales history entries.", (Object)this.getEntriesAmount());
    }

    public void reset() {
        this.history.clear();
    }
}

