/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client;

import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.preset.PresetClient;
import austeretony.oxygen_core.common.persistent.PersistentData;
import austeretony.oxygen_trade.client.OffersContainerClient;
import austeretony.oxygen_trade.client.OffersManagerClient;
import austeretony.oxygen_trade.client.SalesHistoryContainerClient;
import austeretony.oxygen_trade.client.SalesHistoryManagerClient;
import austeretony.oxygen_trade.client.TradeMenuManagerClient;
import austeretony.oxygen_trade.client.categories.ItemCategoriesPresetClient;

public final class TradeManagerClient {
    private static TradeManagerClient instance;
    private final OffersContainerClient offersContainer = new OffersContainerClient();
    private final SalesHistoryContainerClient salesHistoryContainer = new SalesHistoryContainerClient();
    private final OffersManagerClient offersManager;
    private final SalesHistoryManagerClient salesHistoryManager;
    private final TradeMenuManagerClient tradeMenuManager = new TradeMenuManagerClient();
    private final ItemCategoriesPresetClient itemCategoriesPreset = new ItemCategoriesPresetClient();

    private TradeManagerClient() {
        this.offersManager = new OffersManagerClient(this);
        this.salesHistoryManager = new SalesHistoryManagerClient(this);
    }

    private void registerPersistentData() {
        OxygenHelperClient.registerPersistentData((PersistentData)this.offersContainer);
        OxygenHelperClient.registerPersistentData((PersistentData)this.salesHistoryContainer);
    }

    private void registerPresets() {
        OxygenHelperClient.registerPreset((PresetClient)this.itemCategoriesPreset);
    }

    public static void create() {
        if (instance == null) {
            instance = new TradeManagerClient();
            instance.registerPersistentData();
            instance.registerPresets();
        }
    }

    public static TradeManagerClient instance() {
        return instance;
    }

    public OffersContainerClient getOffersContainer() {
        return this.offersContainer;
    }

    public SalesHistoryContainerClient getSalesHistoryContainer() {
        return this.salesHistoryContainer;
    }

    public OffersManagerClient getOffersManager() {
        return this.offersManager;
    }

    public SalesHistoryManagerClient getSalesHistoryManager() {
        return this.salesHistoryManager;
    }

    public TradeMenuManagerClient getTradeMenuManager() {
        return this.tradeMenuManager;
    }

    public ItemCategoriesPresetClient getItemCategoriesPreset() {
        return this.itemCategoriesPreset;
    }

    public void worldLoaded() {
        this.load();
    }

    public void load() {
        OxygenHelperClient.loadPersistentDataAsync((PersistentData)this.offersContainer);
    }
}

