/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client.categories;

import austeretony.oxygen_core.client.preset.PresetClient;
import austeretony.oxygen_core.common.util.JsonUtils;
import austeretony.oxygen_trade.client.categories.OfferCategoryClient;
import austeretony.oxygen_trade.client.categories.SubCategoryCommon;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ItemCategoriesPresetClient
implements PresetClient {
    public static final OfferCategoryClient COMMON_CATEGORY = new OfferCategoryClient("oxygen_trade.category.common");
    private long versionId;
    private final List<OfferCategoryClient> categories = new ArrayList<OfferCategoryClient>(3);
    private boolean verified;

    public boolean isVerified() {
        return this.verified;
    }

    public List<OfferCategoryClient> getCategories() {
        return this.categories;
    }

    public int getId() {
        return 100;
    }

    public String getDomain() {
        return "trade";
    }

    public String getDisplayName() {
        return "item_categories";
    }

    public long getVersionId() {
        return this.versionId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadVersionId(String folder) {
        this.versionId = 0L;
        String pathStr = folder + "/item_categories_version.txt";
        Path path = Paths.get(pathStr, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) return false;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(pathStr));){
            this.versionId = Long.parseLong(bufferedReader.readLine());
            boolean bl = true;
            return bl;
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean load(String folder) {
        String pathStr = folder + "/item_categories.json";
        Path path = Paths.get(pathStr, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            this.categories.clear();
            try {
                this.categories.add(COMMON_CATEGORY);
                for (JsonElement categoryEntry : JsonUtils.getExternalJsonData((String)pathStr).getAsJsonArray()) {
                    this.categories.add(OfferCategoryClient.deserialize(categoryEntry.getAsJsonObject()));
                }
                this.sortCategories();
                this.verified = true;
                return true;
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    private void sortCategories() {
        Collections.sort(this.categories, (c1, c2) -> c1.localizedName().compareTo(c2.localizedName()));
    }

    public boolean save(String folder) {
        String pathStr = folder + "/item_categories.json";
        Path path = Paths.get(pathStr, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        try {
            JsonArray config = new JsonArray();
            for (OfferCategoryClient category : this.categories) {
                config.add((JsonElement)category.serialize());
            }
            JsonUtils.createExternalJsonFile((String)pathStr, (JsonElement)config);
            return this.saveVersionId(folder);
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean reloadAfterSave() {
        return true;
    }

    private boolean saveVersionId(String folder) {
        String idPathStr = folder + "/item_categories_version.txt";
        Path idPath = Paths.get(idPathStr, new String[0]);
        try {
            Files.createDirectories(idPath.getParent(), new FileAttribute[0]);
            try (PrintStream printStream = new PrintStream(new File(idPathStr));){
                printStream.println(this.versionId);
            }
            return true;
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void read(ByteBuf buffer) {
        this.categories.clear();
        this.versionId = buffer.readLong();
        int amount = buffer.readByte();
        for (int i = 0; i < amount; ++i) {
            this.categories.add(OfferCategoryClient.read(buffer));
        }
    }

    static {
        ItemCategoriesPresetClient.COMMON_CATEGORY.subCategories.add(new SubCategoryCommon("oxygen_trade.category.common"));
    }
}

