/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client.categories;

import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_trade.common.categories.EnumCategoriesFileKey;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.util.ResourceLocation;

public class OfferSubCategoryClient {
    public final String name;
    protected final Set<ResourceLocation> registryNames = new HashSet<ResourceLocation>();

    public OfferSubCategoryClient(String name) {
        this.name = name;
    }

    public boolean isValid(ResourceLocation registryName) {
        return this.registryNames.contains(registryName);
    }

    public String localizedName() {
        return ClientReference.localize((String)this.name, (Object[])new Object[0]);
    }

    protected static OfferSubCategoryClient deserialize(JsonObject jsonObject) {
        OfferSubCategoryClient subCategory = new OfferSubCategoryClient(jsonObject.get(EnumCategoriesFileKey.NAME.get()).getAsString());
        for (JsonElement itemEntry : jsonObject.get(EnumCategoriesFileKey.ITEMS.get()).getAsJsonArray()) {
            subCategory.registryNames.add(new ResourceLocation(itemEntry.getAsString()));
        }
        return subCategory;
    }

    protected JsonObject serialize() {
        JsonObject subCategoryEntry = new JsonObject();
        subCategoryEntry.add(EnumCategoriesFileKey.NAME.get(), (JsonElement)new JsonPrimitive(this.name));
        JsonArray itemEntries = new JsonArray();
        for (ResourceLocation registryName : this.registryNames) {
            itemEntries.add((JsonElement)new JsonPrimitive(registryName.toString()));
        }
        subCategoryEntry.add(EnumCategoriesFileKey.ITEMS.get(), (JsonElement)itemEntries);
        return subCategoryEntry;
    }

    protected static OfferSubCategoryClient read(ByteBuf buffer) {
        OfferSubCategoryClient subCategory = new OfferSubCategoryClient(ByteBufUtils.readString((ByteBuf)buffer));
        int amount = buffer.readShort();
        for (int i = 0; i < amount; ++i) {
            subCategory.registryNames.add(new ResourceLocation(ByteBufUtils.readString((ByteBuf)buffer)));
        }
        return subCategory;
    }
}

