/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client.gui.trade;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.contextmenu.GUIContextMenu;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenGUIHelper;
import austeretony.oxygen_core.client.api.WatcherHelperClient;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.elements.CurrencyValueGUIElement;
import austeretony.oxygen_core.client.gui.elements.InventoryLoadGUIElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenu;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenuElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIDDList;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIDDListElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.elements.OxygenTexturedGUIButton;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_trade.client.PlayerOfferClient;
import austeretony.oxygen_trade.client.TradeManagerClient;
import austeretony.oxygen_trade.client.categories.ItemCategoriesPresetClient;
import austeretony.oxygen_trade.client.categories.OfferCategoryClient;
import austeretony.oxygen_trade.client.categories.OfferSubCategoryClient;
import austeretony.oxygen_trade.client.gui.trade.TradeMenuGUIScreen;
import austeretony.oxygen_trade.client.gui.trade.buy.BuySectionGUIFiller;
import austeretony.oxygen_trade.client.gui.trade.buy.EnumOffersSorter;
import austeretony.oxygen_trade.client.gui.trade.buy.OfferGUIButton;
import austeretony.oxygen_trade.client.gui.trade.buy.context.PurchaseItemContextAction;
import austeretony.oxygen_trade.client.input.TradeKeyHandler;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.EnumRarity;

public class BuyGUISection
extends AbstractGUISection {
    private final TradeMenuGUIScreen screen;
    private OxygenGUIButton searchButton;
    private OxygenGUIText offersAmountLabel;
    private OxygenGUIText offersEmptyLabel;
    private OxygenTexturedGUIButton resetFiltersButton;
    private OxygenGUIButtonPanel offersPanel;
    private OxygenGUIDDList categoryDDList;
    private OxygenGUIDDList subCategoryDDList;
    private OxygenGUIDDList sorterDDList;
    private OxygenGUIDDList rarityDDList;
    private OxygenGUITextField minPriceField;
    private OxygenGUITextField maxPriceField;
    private OxygenGUITextField searchField;
    private InventoryLoadGUIElement inventoryLoadElement;
    private CurrencyValueGUIElement balanceElement;
    private OfferCategoryClient currentCategory = ItemCategoriesPresetClient.COMMON_CATEGORY;
    private OfferSubCategoryClient currentSubCategory;
    private EnumOffersSorter currentOffersSorter = EnumOffersSorter.PURCHASE_PRICE;
    private int currentRarityIndex = -1;

    public BuyGUISection(TradeMenuGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new BuySectionGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_trade.gui.trade.title", (Object[])new Object[0]), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.resetFiltersButton = new OxygenTexturedGUIButton(69, 18, 5, 5, OxygenGUITextures.CROSS_ICONS, 5, 5, ClientReference.localize((String)"oxygen_trade.gui.trade.tooltip.resetFilters", (Object[])new Object[0]));
        this.addElement((GUIBaseElement)this.resetFiltersButton);
        this.offersPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 76, 16, this.getWidth() - 85, 16, 1, 9, 9, GUISettings.get().getSubTextScale(), true);
        this.addElement((GUIBaseElement)this.offersPanel);
        this.offersPanel.initContextMenu((GUIContextMenu)new OxygenGUIContextMenu(GUISettings.get().getContextMenuWidth(), 9, new OxygenGUIContextMenuElement.ContextMenuAction[]{new PurchaseItemContextAction()}));
        this.offersPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0 && !clicked.isOverpriced() && !clicked.isPurchased()) {
                TradeManagerClient.instance().getOffersManager().purchaseItemSynced((Long)clicked.index);
            }
        });
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getSellingSection(), this.screen.getOffersSection(), this.screen.getSalesHistorySection()}));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 75, ClientReference.localize((String)"oxygen_trade.gui.trade.priceRange", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.minPriceField = new OxygenGUITextField(6, 82, 30, 8, 10, "", 3, true, -1L);
        this.addElement((GUIBaseElement)this.minPriceField);
        this.addElement((GUIBaseElement)new OxygenGUIText(38, 84, "-", GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColor()));
        this.maxPriceField = new OxygenGUITextField(43, 82, 30, 8, 10, "", 3, true, -1L);
        this.addElement((GUIBaseElement)this.maxPriceField);
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 95, ClientReference.localize((String)"oxygen_trade.gui.trade.search", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.searchField = new OxygenGUITextField(6, 102, 67, 8, 20, "...", 3, false, -1L);
        this.addElement((GUIBaseElement)this.searchField);
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 18, ClientReference.localize((String)"oxygen_trade.gui.trade.category", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 37, ClientReference.localize((String)"oxygen_trade.gui.trade.subCategory", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 56, ClientReference.localize((String)"oxygen_trade.gui.trade.sortBy", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 115, ClientReference.localize((String)"oxygen_trade.gui.trade.rarity", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.searchButton = (OxygenGUIButton)new OxygenGUIButton(20, this.getHeight() - 14, 40, 10, ClientReference.localize((String)"oxygen_trade.gui.trade.searchButton", (Object[])new Object[0])).disable();
        this.addElement((GUIBaseElement)this.searchButton);
        this.offersAmountLabel = (OxygenGUIText)new OxygenGUIText(0, this.getHeight() - 22, "", GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColor()).disableFull();
        this.addElement((GUIBaseElement)this.offersAmountLabel);
        this.inventoryLoadElement = new InventoryLoadGUIElement(78, this.getHeight() - 9, EnumGUIAlignment.RIGHT);
        this.addElement((GUIBaseElement)this.inventoryLoadElement);
        this.inventoryLoadElement.updateLoad();
        this.balanceElement = new CurrencyValueGUIElement(this.getWidth() - 19, this.getHeight() - 10);
        this.addElement((GUIBaseElement)this.balanceElement);
        this.balanceElement.setValue(WatcherHelperClient.getLong((int)0));
        this.rarityDDList = new OxygenGUIDDList(6, 123, 75, 9, ClientReference.localize((String)"oxygen_trade.rarity.any", (Object[])new Object[0]));
        this.rarityDDList.addElement(new OxygenGUIDDListElement((Object)-1, ClientReference.localize((String)"oxygen_trade.rarity.any", (Object[])new Object[0])));
        for (EnumRarity enumRarity : EnumRarity.values()) {
            this.rarityDDList.addElement(new OxygenGUIDDListElement((Object)enumRarity.ordinal(), BuyGUISection.getRarityName(enumRarity)));
        }
        this.addElement((GUIBaseElement)this.rarityDDList);
        this.rarityDDList.setClickListener(element -> {
            this.currentRarityIndex = (Integer)element.index;
        });
        this.sorterDDList = new OxygenGUIDDList(6, 63, 75, 9, EnumOffersSorter.PURCHASE_PRICE.localizedName());
        for (EnumRarity enumRarity : EnumOffersSorter.values()) {
            this.sorterDDList.addElement(new OxygenGUIDDListElement((Object)enumRarity, enumRarity.localizedName()));
        }
        this.addElement((GUIBaseElement)this.sorterDDList);
        this.sorterDDList.setClickListener(element -> {
            this.currentOffersSorter = (EnumOffersSorter)((Object)((Object)((Object)element.index)));
        });
        this.subCategoryDDList = new OxygenGUIDDList(6, 44, 75, 9, "");
        this.addElement((GUIBaseElement)this.subCategoryDDList);
        this.subCategoryDDList.setClickListener(element -> {
            this.currentSubCategory = (OfferSubCategoryClient)element.index;
        });
        this.loadSubCategories(ItemCategoriesPresetClient.COMMON_CATEGORY);
        this.categoryDDList = new OxygenGUIDDList(6, 25, 75, 9, ItemCategoriesPresetClient.COMMON_CATEGORY.localizedName());
        for (OfferCategoryClient category : TradeManagerClient.instance().getItemCategoriesPreset().getCategories()) {
            this.categoryDDList.addElement(new OxygenGUIDDListElement((Object)category, category.localizedName()));
        }
        this.addElement((GUIBaseElement)this.categoryDDList);
        this.categoryDDList.setClickListener(element -> {
            this.currentCategory = (OfferCategoryClient)element.index;
            this.loadSubCategories(this.currentCategory);
        });
        String offersEmpty = ClientReference.localize((String)"oxygen_trade.gui.trade.noOffersFound", (Object[])new Object[0]);
        this.offersEmptyLabel = (OxygenGUIText)new OxygenGUIText(76 + (this.offersPanel.getButtonWidth() - this.textWidth(offersEmpty, GUISettings.get().getSubTextScale() - 0.05f)) / 2, 20, offersEmpty, GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColorDark()).setVisible(false);
        this.addElement((GUIBaseElement)this.offersEmptyLabel);
    }

    private void loadSubCategories(OfferCategoryClient category) {
        this.currentSubCategory = category.getSubCategories().get(0);
        this.subCategoryDDList.reset();
        this.subCategoryDDList.setDisplayText(this.currentSubCategory.localizedName());
        for (OfferSubCategoryClient subCategory : category.getSubCategories()) {
            this.subCategoryDDList.addElement(new OxygenGUIDDListElement((Object)subCategory, subCategory.localizedName()));
        }
    }

    private static String getRarityName(EnumRarity rarity) {
        return rarity.field_77937_e + ClientReference.localize((String)rarity.field_77934_f, (Object[])new Object[0]);
    }

    public void filterOffers() {
        List<PlayerOfferClient> offers = this.getOffersAndApplyFilters();
        this.offersEmptyLabel.setVisible(offers.isEmpty());
        this.offersPanel.reset();
        for (PlayerOfferClient offer : offers) {
            this.offersPanel.addButton((GUIButton)new OfferGUIButton(offer, this.screen.getEqualStackAmount(offer.getOfferedStack()), offer.getPrice() > this.balanceElement.getValue()));
        }
        this.offersPanel.getScroller().resetPosition();
        this.offersPanel.getScroller().getSlider().reset();
        this.offersPanel.getScroller().updateRowsAmount(MathUtils.clamp((int)offers.size(), (int)9, (int)3000));
        this.offersAmountLabel.setDisplayText(String.valueOf(offers.size()) + "/" + String.valueOf(TradeManagerClient.instance().getOffersContainer().getOffersAmount()));
        this.offersAmountLabel.setX((80 - this.textWidth(this.offersAmountLabel.getDisplayText(), this.offersAmountLabel.getTextScale())) / 2);
    }

    private List<PlayerOfferClient> getOffersAndApplyFilters() {
        return TradeManagerClient.instance().getOffersContainer().getOffers().stream().filter(offer -> this.filterCategory((PlayerOfferClient)offer)).filter(offer -> this.filterPrice((PlayerOfferClient)offer)).filter(offer -> this.filterName((PlayerOfferClient)offer)).filter(offer -> this.filterRarity((PlayerOfferClient)offer)).sorted((o1, o2) -> o1.getOfferedStack().itemId - o2.getOfferedStack().itemId).sorted(this.currentOffersSorter.comparator).collect(Collectors.toList());
    }

    private boolean filterCategory(PlayerOfferClient offer) {
        return this.currentCategory.isValid(this.currentSubCategory, offer.getOfferedStack().getCachedItemStack().func_77973_b().getRegistryName());
    }

    private boolean filterPrice(PlayerOfferClient offer) {
        long minPrice = this.minPriceField.getTypedNumber();
        long maxPrice = this.maxPriceField.getTypedNumber();
        if (maxPrice != 0L && minPrice <= maxPrice) {
            return offer.getPrice() >= minPrice && offer.getPrice() <= maxPrice;
        }
        return true;
    }

    private boolean filterName(PlayerOfferClient offer) {
        return this.searchField.getTypedText().isEmpty() || offer.getOfferedStack().getCachedItemStack().func_82833_r().contains(this.searchField.getTypedText());
    }

    private boolean filterRarity(PlayerOfferClient offer) {
        return this.currentRarityIndex == -1 || offer.getOfferedStack().getCachedItemStack().func_77953_t().ordinal() == this.currentRarityIndex;
    }

    public void setSearchButtonState(boolean flag) {
        this.searchButton.setEnabled(flag);
        if (flag) {
            this.offersAmountLabel.enableFull();
            this.offersAmountLabel.setDisplayText("0/" + String.valueOf(TradeManagerClient.instance().getOffersContainer().getOffersAmount()));
            this.offersAmountLabel.setX((80 - this.textWidth(this.offersAmountLabel.getDisplayText(), this.offersAmountLabel.getTextScale())) / 2);
        }
    }

    private void resetFilters() {
        this.currentCategory = ItemCategoriesPresetClient.COMMON_CATEGORY;
        this.categoryDDList.setDisplayText(ItemCategoriesPresetClient.COMMON_CATEGORY.localizedName());
        this.loadSubCategories(this.currentCategory);
        this.currentOffersSorter = EnumOffersSorter.PURCHASE_PRICE;
        this.sorterDDList.setDisplayText(EnumOffersSorter.PURCHASE_PRICE.localizedName());
        this.currentRarityIndex = -1;
        this.rarityDDList.setDisplayText(ClientReference.localize((String)"oxygen_trade.rarity.any", (Object[])new Object[0]));
        this.minPriceField.reset();
        this.maxPriceField.reset();
        this.searchField.reset();
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (!(this.searchField.isDragged() || this.minPriceField.isDragged() || this.maxPriceField.isDragged() || this.hasCurrentCallback())) {
            if (OxygenGUIHelper.isOxygenMenuEnabled()) {
                if (keyCode == TradeMenuGUIScreen.TRADE_MENU_ENTRY.getIndex() + 2) {
                    this.screen.close();
                }
            } else if (keyCode == TradeKeyHandler.TRADE_MENU.func_151463_i()) {
                this.screen.close();
            }
        }
        return super.keyTyped(typedChar, keyCode);
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0) {
            if (element == this.searchButton) {
                this.filterOffers();
            } else if (element == this.resetFiltersButton) {
                this.resetFilters();
            }
        }
    }

    public void itemPurchased(PlayerOfferClient offer, long balance) {
        this.balanceElement.setValue(balance);
        for (GUIButton b : this.offersPanel.buttonsBuffer) {
            OfferGUIButton button = (OfferGUIButton)b;
            if (button.price > balance) {
                button.setOverpriced();
            }
            if (((Long)button.index).longValue() != offer.getId()) continue;
            button.setPurchased();
        }
        this.offersAmountLabel.setDisplayText(String.valueOf(this.offersPanel.buttonsBuffer.size() - 1) + "/" + String.valueOf(TradeManagerClient.instance().getOffersContainer().getOffersAmount()));
    }

    public void offerCreated(PlayerOfferClient offer, long balance) {
        this.balanceElement.setValue(balance);
        this.inventoryLoadElement.setLoad(this.screen.getSellingSection().getInventoryLoadElement().getLoad());
        for (GUIButton b : this.offersPanel.buttonsBuffer) {
            OfferGUIButton button = (OfferGUIButton)b;
            if (button.price <= balance) continue;
            button.setOverpriced();
        }
        this.offersAmountLabel.setDisplayText(String.valueOf(this.offersPanel.buttonsBuffer.size()) + "/" + String.valueOf(TradeManagerClient.instance().getOffersContainer().getOffersAmount()));
    }

    public void offerCanceled(PlayerOfferClient offer, long balance) {
        if (!this.offersPanel.buttonsBuffer.isEmpty()) {
            this.filterOffers();
        }
    }

    public InventoryLoadGUIElement getInventoryLoadElement() {
        return this.inventoryLoadElement;
    }

    public CurrencyValueGUIElement getBalanceElement() {
        return this.balanceElement;
    }
}

