/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client.gui.trade;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.contextmenu.GUIContextMenu;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenu;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIContextMenuElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_trade.client.PlayerOfferClient;
import austeretony.oxygen_trade.client.TradeManagerClient;
import austeretony.oxygen_trade.client.gui.trade.TradeMenuGUIScreen;
import austeretony.oxygen_trade.client.gui.trade.offers.OffersSectionGUIFiller;
import austeretony.oxygen_trade.client.gui.trade.offers.PlayerOfferGUIButton;
import austeretony.oxygen_trade.client.gui.trade.offers.TotalPriceGUIElement;
import austeretony.oxygen_trade.client.gui.trade.offers.context.CancelOfferContextAction;
import austeretony.oxygen_trade.client.gui.trade.selling.OffersAmountGUIElement;
import java.util.Collections;
import java.util.List;

public class OffersGUISection
extends AbstractGUISection {
    private final TradeMenuGUIScreen screen;
    private OxygenGUIText offersEmptyLabel;
    private OxygenGUIButtonPanel playerOffersPanel;
    private OffersAmountGUIElement offersAmountElement;
    private TotalPriceGUIElement totalPriceElement;

    public OffersGUISection(TradeMenuGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new OffersSectionGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_trade.gui.trade.title", (Object[])new Object[0]), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.offersAmountElement = new OffersAmountGUIElement(4, this.getHeight() - 10);
        this.addElement((GUIBaseElement)this.offersAmountElement);
        this.playerOffersPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 6, 16, this.getWidth() - 15, 16, 1, 9, 9, GUISettings.get().getSubTextScale(), true);
        this.addElement((GUIBaseElement)this.playerOffersPanel);
        this.playerOffersPanel.initContextMenu((GUIContextMenu)new OxygenGUIContextMenu(GUISettings.get().getContextMenuWidth(), 9, new OxygenGUIContextMenuElement.ContextMenuAction[]{new CancelOfferContextAction()}));
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getBuySection(), this.screen.getSellingSection(), this.screen.getSalesHistorySection()}));
        this.totalPriceElement = new TotalPriceGUIElement(this.getWidth() - 19, this.getHeight() - 10);
        this.addElement((GUIBaseElement)this.totalPriceElement);
        this.totalPriceElement.setValue(this.screen.getBuySection().getBalanceElement().getValue());
        String offersEmpty = ClientReference.localize((String)"oxygen_trade.gui.trade.noOffersFound", (Object[])new Object[0]);
        this.offersEmptyLabel = (OxygenGUIText)new OxygenGUIText((this.getWidth() - this.textWidth(offersEmpty, GUISettings.get().getSubTextScale() - 0.05f)) / 2, 20, offersEmpty, GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColorDark()).setVisible(false);
        this.addElement((GUIBaseElement)this.offersEmptyLabel);
    }

    public void updateOffersAmount() {
        this.offersAmountElement.setOffersAmount(this.screen.getSellingSection().getOffersAmountElement().getOffersAmount());
    }

    public void loadPlayerOffers() {
        List<PlayerOfferClient> offers = TradeManagerClient.instance().getOffersManager().getPlayerOffers();
        Collections.sort(offers, (o1, o2) -> (int)((o1.getId() - o2.getId()) / 1000L));
        this.offersEmptyLabel.setVisible(offers.isEmpty());
        this.playerOffersPanel.reset();
        int totalPrice = 0;
        for (PlayerOfferClient offer : offers) {
            totalPrice = (int)((long)totalPrice + offer.getPrice());
            this.playerOffersPanel.addButton((GUIButton)new PlayerOfferGUIButton(offer));
        }
        this.totalPriceElement.setValue(totalPrice);
        this.playerOffersPanel.getScroller().resetPosition();
        this.playerOffersPanel.getScroller().getSlider().reset();
        this.playerOffersPanel.getScroller().updateRowsAmount(MathUtils.clamp((int)offers.size(), (int)9, (int)this.offersAmountElement.getMaxAmount()));
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
    }

    public void itemPurchased(PlayerOfferClient offer, long balance) {
        if (offer.isOwner(OxygenHelperClient.getPlayerUsername())) {
            this.offersAmountElement.decrementOffersAmount(1);
            this.loadPlayerOffers();
        }
    }

    public void offerCreated(PlayerOfferClient offer, long balance) {
        this.loadPlayerOffers();
        this.offersAmountElement.incrementOffersAmount(1);
    }

    public void offerCanceled(PlayerOfferClient offer, long balance) {
        this.loadPlayerOffers();
        this.offersAmountElement.decrementOffersAmount(1);
    }

    public OffersAmountGUIElement getOffersAmountElement() {
        return this.offersAmountElement;
    }
}

