/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client.gui.trade;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIDDList;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIDDListElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_trade.client.SalesHistoryEntryClient;
import austeretony.oxygen_trade.client.TradeManagerClient;
import austeretony.oxygen_trade.client.gui.trade.TradeMenuGUIScreen;
import austeretony.oxygen_trade.client.gui.trade.buy.BuySectionGUIFiller;
import austeretony.oxygen_trade.client.gui.trade.history.EnumSalesHistoryFilter;
import austeretony.oxygen_trade.client.gui.trade.history.SalesHistoryEntryGUIButton;
import java.util.List;

public class SalesHistoryGUISection
extends AbstractGUISection {
    private final TradeMenuGUIScreen screen;
    private OxygenGUIButton filterButton;
    private OxygenGUIText entriesAmountLabel;
    private OxygenGUIText offersEmptyLabel;
    private OxygenGUIButtonPanel offersPanel;
    private OxygenGUIDDList filterDDList;
    private EnumSalesHistoryFilter currentFilter = EnumSalesHistoryFilter.PURCHASES;
    private int playerEntriesAmount;

    public SalesHistoryGUISection(TradeMenuGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new BuySectionGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_trade.gui.trade.title", (Object[])new Object[0]), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.offersPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 76, 16, this.getWidth() - 85, 16, 1, 9, 9, GUISettings.get().getSubTextScale(), true);
        this.addElement((GUIBaseElement)this.offersPanel);
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getBuySection(), this.screen.getSellingSection(), this.screen.getOffersSection()}));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 18, ClientReference.localize((String)"oxygen_trade.gui.trade.filter", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.filterDDList = new OxygenGUIDDList(6, 25, 75, 9, EnumSalesHistoryFilter.PURCHASES.localizedName());
        for (EnumSalesHistoryFilter filter : EnumSalesHistoryFilter.values()) {
            this.filterDDList.addElement(new OxygenGUIDDListElement((Object)filter, filter.localizedName()));
        }
        this.addElement((GUIBaseElement)this.filterDDList);
        this.filterDDList.setClickListener(element -> {
            this.currentFilter = (EnumSalesHistoryFilter)((Object)((Object)element.index));
        });
        this.filterButton = (OxygenGUIButton)new OxygenGUIButton(20, this.getHeight() - 14, 40, 10, ClientReference.localize((String)"oxygen_trade.gui.trade.filterButton", (Object[])new Object[0])).disable();
        this.addElement((GUIBaseElement)this.filterButton);
        this.entriesAmountLabel = (OxygenGUIText)new OxygenGUIText(0, this.getHeight() - 22, "", GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColor()).disableFull();
        this.addElement((GUIBaseElement)this.entriesAmountLabel);
        String offersEmpty = ClientReference.localize((String)"oxygen_trade.gui.trade.noDataFound", (Object[])new Object[0]);
        this.offersEmptyLabel = (OxygenGUIText)new OxygenGUIText(76 + (this.offersPanel.getButtonWidth() - this.textWidth(offersEmpty, GUISettings.get().getSubTextScale() - 0.05f)) / 2, 20, offersEmpty, GUISettings.get().getSubTextScale() - 0.05f, GUISettings.get().getEnabledTextColorDark()).setVisible(false);
        this.addElement((GUIBaseElement)this.offersEmptyLabel);
    }

    public void filterHistory() {
        List<SalesHistoryEntryClient> entries = null;
        switch (this.currentFilter) {
            case PURCHASES: {
                entries = TradeManagerClient.instance().getSalesHistoryManager().getPlayerPurchaseEntries();
                break;
            }
            case SALES: {
                entries = TradeManagerClient.instance().getSalesHistoryManager().getPlayerSaleEntries();
            }
        }
        this.offersEmptyLabel.setVisible(entries.isEmpty());
        this.offersPanel.reset();
        for (SalesHistoryEntryClient entry : entries) {
            this.offersPanel.addButton((GUIButton)new SalesHistoryEntryGUIButton(entry, this.currentFilter));
        }
        this.offersPanel.getScroller().resetPosition();
        this.offersPanel.getScroller().getSlider().reset();
        this.offersPanel.getScroller().updateRowsAmount(MathUtils.clamp((int)entries.size(), (int)9, (int)3000));
        this.entriesAmountLabel.setDisplayText(String.valueOf(entries.size()) + "/" + String.valueOf(this.playerEntriesAmount));
        this.entriesAmountLabel.setX((80 - this.textWidth(this.entriesAmountLabel.getDisplayText(), this.entriesAmountLabel.getTextScale())) / 2);
    }

    public void enableFilterButton() {
        this.filterButton.enable();
        this.playerEntriesAmount = TradeManagerClient.instance().getSalesHistoryManager().getHistoryEntriesAmountForPlayer();
        this.entriesAmountLabel.enableFull();
        this.entriesAmountLabel.setDisplayText("0/" + String.valueOf(this.playerEntriesAmount));
        this.entriesAmountLabel.setX((80 - this.textWidth(this.entriesAmountLabel.getDisplayText(), this.entriesAmountLabel.getTextScale())) / 2);
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0 && element == this.filterButton) {
            this.filterHistory();
        }
    }
}

