/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client.gui.trade;

import austeretony.alternateui.screen.button.GUIButton;
import austeretony.alternateui.screen.callback.AbstractGUICallback;
import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenGUIHelper;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.api.PrivilegeProviderClient;
import austeretony.oxygen_core.client.gui.elements.CurrencyValueGUIElement;
import austeretony.oxygen_core.client.gui.elements.InventoryLoadGUIElement;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButton;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIButtonPanel;
import austeretony.oxygen_core.client.gui.elements.OxygenGUIText;
import austeretony.oxygen_core.client.gui.elements.OxygenGUITextField;
import austeretony.oxygen_core.client.gui.elements.SectionsGUIDDList;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_trade.client.PlayerOfferClient;
import austeretony.oxygen_trade.client.gui.trade.TradeMenuGUIScreen;
import austeretony.oxygen_trade.client.gui.trade.buy.BuySectionGUIFiller;
import austeretony.oxygen_trade.client.gui.trade.selling.InventoryItemGUIButton;
import austeretony.oxygen_trade.client.gui.trade.selling.ItemGUIElement;
import austeretony.oxygen_trade.client.gui.trade.selling.OffersAmountGUIElement;
import austeretony.oxygen_trade.client.gui.trade.selling.callback.OfferCreationGUICallback;
import austeretony.oxygen_trade.client.input.TradeKeyHandler;
import austeretony.oxygen_trade.common.config.TradeConfig;
import austeretony.oxygen_trade.common.main.EnumTradePrivilege;
import java.util.HashSet;
import net.minecraft.item.ItemStack;

public class SellingGUISection
extends AbstractGUISection {
    private final TradeMenuGUIScreen screen;
    private OxygenGUIButton createOfferButton;
    private OxygenGUIButtonPanel inventoryContentPanel;
    private OxygenGUITextField amountField;
    private OxygenGUITextField unitPriceField;
    private OxygenGUITextField totalPriceField;
    private ItemGUIElement itemElement;
    private OffersAmountGUIElement offersAmountElement;
    private InventoryLoadGUIElement inventoryLoadElement;
    private CurrencyValueGUIElement offerCreationFeeElement;
    private CurrencyValueGUIElement saleFeeElement;
    private CurrencyValueGUIElement profitElement;
    private CurrencyValueGUIElement balanceElement;
    private AbstractGUICallback offerCreationCallback;
    private InventoryItemGUIButton currentItemButton;

    public SellingGUISection(TradeMenuGUIScreen screen) {
        super((AbstractGUIScreen)screen);
        this.screen = screen;
    }

    public void init() {
        this.addElement((GUIBaseElement)new BuySectionGUIFiller(0, 0, this.getWidth(), this.getHeight()));
        this.addElement((GUIBaseElement)new OxygenGUIText(4, 5, ClientReference.localize((String)"oxygen_trade.gui.trade.title", (Object[])new Object[0]), GUISettings.get().getTitleScale(), GUISettings.get().getEnabledTextColor()));
        this.offersAmountElement = new OffersAmountGUIElement(6, 18);
        this.addElement((GUIBaseElement)this.offersAmountElement);
        this.itemElement = new ItemGUIElement(6, 28);
        this.addElement((GUIBaseElement)this.itemElement);
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 48, ClientReference.localize((String)"oxygen_trade.gui.trade.amount", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.amountField = new OxygenGUITextField(6, 55, 40, 8, 10, "", 3, true, -1L);
        this.addElement((GUIBaseElement)this.amountField);
        this.amountField.setInputListener((charCode, keyCode) -> this.calculateFeesAndProfit(EnumField.AMOUNT));
        long maxPrice = PrivilegeProviderClient.getValue((String)EnumTradePrivilege.PRICE_MAX_VALUE.toString(), (long)TradeConfig.PRICE_MAX_VALUE.getLongValue());
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 68, ClientReference.localize((String)"oxygen_trade.gui.trade.unitPrice", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.unitPriceField = new OxygenGUITextField(6, 75, 40, 8, 10, "", 3, true, maxPrice);
        this.addElement((GUIBaseElement)this.unitPriceField);
        this.unitPriceField.setInputListener((charCode, keyCode) -> this.calculateFeesAndProfit(EnumField.UNIT_PRICE));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 88, ClientReference.localize((String)"oxygen_trade.gui.trade.totalPrice", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.totalPriceField = new OxygenGUITextField(6, 95, 40, 8, 10, "", 3, true, maxPrice);
        this.addElement((GUIBaseElement)this.totalPriceField);
        this.totalPriceField.setInputListener((charCode, keyCode) -> this.calculateFeesAndProfit(EnumField.TOTAL_PRICE));
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 112, ClientReference.localize((String)"oxygen_trade.gui.trade.listingFee", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.offerCreationFeeElement = new CurrencyValueGUIElement(68, 112);
        this.addElement((GUIBaseElement)this.offerCreationFeeElement);
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 122, ClientReference.localize((String)"oxygen_trade.gui.trade.saleFee", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.saleFeeElement = new CurrencyValueGUIElement(68, 122);
        this.addElement((GUIBaseElement)this.saleFeeElement);
        this.addElement((GUIBaseElement)new OxygenGUIText(6, 132, ClientReference.localize((String)"oxygen_trade.gui.trade.profit", (Object[])new Object[0]), GUISettings.get().getSubTextScale(), GUISettings.get().getEnabledTextColorDark()));
        this.profitElement = new CurrencyValueGUIElement(68, 132);
        this.addElement((GUIBaseElement)this.profitElement);
        this.createOfferButton = (OxygenGUIButton)new OxygenGUIButton(20, this.getHeight() - 14, 40, 10, ClientReference.localize((String)"oxygen_trade.gui.trade.createOfferButton", (Object[])new Object[0])).disable();
        this.addElement((GUIBaseElement)this.createOfferButton);
        this.inventoryContentPanel = new OxygenGUIButtonPanel((AbstractGUIScreen)this.screen, 76, 16, this.getWidth() - 85, 16, 1, 36, 9, GUISettings.get().getSubTextScale(), true);
        this.addElement((GUIBaseElement)this.inventoryContentPanel);
        this.loadInventoryContent();
        this.inventoryContentPanel.setClickListener((previous, clicked, mouseX, mouseY, mouseButton) -> {
            if (mouseButton == 0) {
                if (previous != null) {
                    previous.setToggled(false);
                }
                clicked.toggle();
                this.currentItemButton = clicked;
                this.updateFields();
                this.itemElement.setItemStack((ItemStack)clicked.index, clicked.getPlayerStock());
            }
        });
        this.addElement((GUIBaseElement)new SectionsGUIDDList(this.getWidth() - 4, 5, new AbstractGUISection[]{this, this.screen.getBuySection(), this.screen.getOffersSection(), this.screen.getSalesHistorySection()}));
        this.inventoryLoadElement = new InventoryLoadGUIElement(78, this.getHeight() - 9, EnumGUIAlignment.RIGHT);
        this.addElement((GUIBaseElement)this.inventoryLoadElement);
        this.inventoryLoadElement.setLoad(this.screen.getBuySection().getInventoryLoadElement().getLoad());
        this.balanceElement = new CurrencyValueGUIElement(this.getWidth() - 19, this.getHeight() - 10);
        this.addElement((GUIBaseElement)this.balanceElement);
        this.balanceElement.setValue(this.screen.getBuySection().getBalanceElement().getValue());
        this.offerCreationCallback = new OfferCreationGUICallback(this.screen, this, 140, 50).enableDefaultBackground();
    }

    private void loadInventoryContent() {
        this.inventoryContentPanel.reset();
        HashSet<String> stacks = new HashSet<String>();
        for (ItemStackWrapper stackWrapper : this.screen.inventoryContent.keySet()) {
            String key = SellingGUISection.getKey(stackWrapper);
            if (stacks.contains(key)) continue;
            this.inventoryContentPanel.addButton((GUIButton)new InventoryItemGUIButton(stackWrapper, this.screen.getEqualStackAmount(stackWrapper)));
            stacks.add(key);
        }
        this.inventoryContentPanel.getScroller().resetPosition();
        this.inventoryContentPanel.getScroller().getSlider().reset();
        this.inventoryContentPanel.getScroller().updateRowsAmount(MathUtils.clamp((int)this.screen.inventoryContent.size(), (int)9, (int)36));
    }

    public void updateOffersAmount() {
        this.offersAmountElement.updateOffersAmount();
    }

    private static String getKey(ItemStackWrapper stackWrapper) {
        return String.valueOf(stackWrapper.itemId) + "_" + String.valueOf(stackWrapper.damage) + "_" + stackWrapper.stackNBTStr + "_" + stackWrapper.capNBTStr;
    }

    private void updateFields() {
        int maxAmount = PrivilegeProviderClient.getValue((String)EnumTradePrivilege.ITEMS_PER_OFFER_MAX_AMOUNT.toString(), (int)TradeConfig.ITEMS_PER_OFFER_MAX_AMOUNT.getIntValue());
        if (maxAmount < 0) {
            maxAmount = ((ItemStack)this.currentItemButton.index).func_77976_d();
        }
        this.amountField.enableNumberFieldMode((long)MathUtils.lesserOfTwo((int)this.currentItemButton.getPlayerStock(), (int)maxAmount));
        this.amountField.setText("1");
        this.unitPriceField.reset();
        this.totalPriceField.reset();
        this.offerCreationFeeElement.setValue(0L);
        this.offerCreationFeeElement.setRed(false);
        this.saleFeeElement.setValue(0L);
        this.profitElement.setValue(0L);
        this.createOfferButton.disable();
    }

    private void calculateFeesAndProfit(EnumField changedField) {
        long amount = this.amountField.getTypedNumber();
        long unitPrice = this.unitPriceField.getTypedNumber();
        long totalPrice = this.totalPriceField.getTypedNumber();
        long result = 0L;
        long maxPrice = PrivilegeProviderClient.getValue((String)EnumTradePrivilege.PRICE_MAX_VALUE.toString(), (long)TradeConfig.PRICE_MAX_VALUE.getLongValue());
        switch (changedField) {
            case AMOUNT: {
                if (unitPrice <= 0L) break;
                result = unitPrice * amount;
                if (result > maxPrice) {
                    return;
                }
                this.totalPriceField.setText(String.valueOf(result));
                break;
            }
            case UNIT_PRICE: {
                if (amount <= 0L) break;
                result = unitPrice * amount;
                if (result > maxPrice) {
                    return;
                }
                this.totalPriceField.setText(String.valueOf(result));
                break;
            }
            case TOTAL_PRICE: {
                if (amount <= 0L) break;
                result = totalPrice;
                this.unitPriceField.setText(String.valueOf(totalPrice / amount));
            }
        }
        long offerCreationFee = MathUtils.percentValueOf((long)result, (int)PrivilegeProviderClient.getValue((String)EnumTradePrivilege.OFFER_CREATION_FEE_PERCENT.toString(), (int)TradeConfig.OFFER_CREATION_FEE_PERCENT.getIntValue()));
        this.offerCreationFeeElement.setValue(offerCreationFee);
        this.offerCreationFeeElement.setRed(offerCreationFee > this.balanceElement.getValue());
        if (!this.offersAmountElement.reachedMaxAmount()) {
            this.createOfferButton.setEnabled(result > 0L && this.balanceElement.getValue() >= offerCreationFee);
        }
        long saleFee = MathUtils.percentValueOf((long)result, (int)PrivilegeProviderClient.getValue((String)EnumTradePrivilege.OFFER_SALE_FEE_PERCENT.toString(), (int)TradeConfig.OFFER_SALE_FEE_PERCENT.getIntValue()));
        this.saleFeeElement.setValue(saleFee);
        this.profitElement.setValue(result - saleFee);
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        if (!(this.amountField.isDragged() || this.unitPriceField.isDragged() || this.totalPriceField.isDragged() || this.hasCurrentCallback())) {
            if (OxygenGUIHelper.isOxygenMenuEnabled()) {
                if (keyCode == TradeMenuGUIScreen.TRADE_MENU_ENTRY.getIndex() + 2) {
                    this.screen.close();
                }
            } else if (keyCode == TradeKeyHandler.TRADE_MENU.func_151463_i()) {
                this.screen.close();
            }
        }
        return super.keyTyped(typedChar, keyCode);
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element, int mouseButton) {
        if (mouseButton == 0 && element == this.createOfferButton) {
            this.offerCreationCallback.open();
        }
    }

    public void setCreateOfferButtonState(boolean enabled) {
        this.createOfferButton.setEnabled(enabled);
    }

    public void itemPurchased(PlayerOfferClient offer, long balance) {
        this.balanceElement.setValue(balance);
        if (offer.isOwner(OxygenHelperClient.getPlayerUsername())) {
            this.offersAmountElement.decrementOffersAmount(1);
        }
    }

    public void offerCreated(PlayerOfferClient offer, long balance) {
        this.balanceElement.setValue(balance);
        this.screen.decrementEqualStackAmount(offer.getOfferedStack(), offer.getAmount());
        this.offersAmountElement.incrementOffersAmount(1);
        if (this.offersAmountElement.reachedMaxAmount()) {
            this.createOfferButton.disable();
        }
        boolean reloadContent = false;
        for (GUIButton b : this.inventoryContentPanel.buttonsBuffer) {
            InventoryItemGUIButton button = (InventoryItemGUIButton)b;
            if (!button.stackWrapper.isEquals(offer.getOfferedStack())) continue;
            button.decrementPlayerStock(offer.getAmount());
            if (!button.isToggled()) continue;
            ItemStack itemStack = offer.getOfferedStack().getItemStack();
            this.inventoryLoadElement.decrementLoad(offer.getAmount() / itemStack.func_77976_d());
            if (button.getPlayerStock() > 0) {
                this.itemElement.setPlayerStock(button.getPlayerStock());
                this.amountField.enableNumberFieldMode((long)button.getPlayerStock());
                if (this.amountField.getTypedNumber() <= (long)button.getPlayerStock()) continue;
                this.amountField.setText(String.valueOf(button.getPlayerStock()));
                this.calculateFeesAndProfit(EnumField.AMOUNT);
                continue;
            }
            reloadContent = true;
            this.itemElement.setVisible(false);
            this.updateFields();
            this.createOfferButton.disable();
            break;
        }
        if (reloadContent) {
            this.loadInventoryContent();
        }
    }

    public void offerCanceled(PlayerOfferClient offer, long balance) {
        this.offersAmountElement.decrementOffersAmount(1);
    }

    public OffersAmountGUIElement getOffersAmountElement() {
        return this.offersAmountElement;
    }

    public InventoryLoadGUIElement getInventoryLoadElement() {
        return this.inventoryLoadElement;
    }

    public CurrencyValueGUIElement getBalanceElement() {
        return this.balanceElement;
    }

    public InventoryItemGUIButton getCurrentItemButton() {
        return this.currentItemButton;
    }

    public OxygenGUITextField getAmountTextField() {
        return this.amountField;
    }

    public OxygenGUITextField getTotalPriceTextField() {
        return this.totalPriceField;
    }

    private static enum EnumField {
        AMOUNT,
        UNIT_PRICE,
        TOTAL_PRICE;

    }
}

