/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client.gui.trade;

import austeretony.alternateui.screen.core.AbstractGUIScreen;
import austeretony.alternateui.screen.core.AbstractGUISection;
import austeretony.alternateui.screen.core.GUIBaseElement;
import austeretony.alternateui.screen.core.GUIWorkspace;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.gui.menu.OxygenMenuEntry;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_trade.client.PlayerOfferClient;
import austeretony.oxygen_trade.client.gui.trade.BuyGUISection;
import austeretony.oxygen_trade.client.gui.trade.OffersGUISection;
import austeretony.oxygen_trade.client.gui.trade.SalesHistoryGUISection;
import austeretony.oxygen_trade.client.gui.trade.SellingGUISection;
import austeretony.oxygen_trade.client.gui.trade.TradeMenuEntry;
import austeretony.oxygen_trade.common.main.EnumOfferAction;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class TradeMenuGUIScreen
extends AbstractGUIScreen {
    public static final OxygenMenuEntry TRADE_MENU_ENTRY = new TradeMenuEntry();
    private BuyGUISection buySection;
    private SellingGUISection sellingSection;
    private OffersGUISection offersSection;
    private SalesHistoryGUISection salesHistorySection;
    public final Map<ItemStackWrapper, Integer> inventoryContent;

    public TradeMenuGUIScreen() {
        OxygenHelperClient.syncData((int)100);
        OxygenHelperClient.syncData((int)101);
        this.inventoryContent = new LinkedHashMap<ItemStackWrapper, Integer>();
        this.updateInventoryContent();
    }

    protected GUIWorkspace initWorkspace() {
        return new GUIWorkspace((AbstractGUIScreen)this, 300, 184).setAlignment(EnumGUIAlignment.RIGHT, -10, 0);
    }

    protected void initSections() {
        this.buySection = (BuyGUISection)((AbstractGUISection)new BuyGUISection(this).setDisplayText(ClientReference.localize((String)"oxygen_trade.gui.trade.buy", (Object[])new Object[0]))).enable();
        this.getWorkspace().initSection((AbstractGUISection)this.buySection);
        this.sellingSection = (SellingGUISection)((AbstractGUISection)new SellingGUISection(this).setDisplayText(ClientReference.localize((String)"oxygen_trade.gui.trade.selling", (Object[])new Object[0]))).enable();
        this.getWorkspace().initSection((AbstractGUISection)this.sellingSection);
        this.offersSection = (OffersGUISection)((AbstractGUISection)new OffersGUISection(this).setDisplayText(ClientReference.localize((String)"oxygen_trade.gui.trade.offers", (Object[])new Object[0]))).enable();
        this.getWorkspace().initSection((AbstractGUISection)this.offersSection);
        this.salesHistorySection = (SalesHistoryGUISection)((AbstractGUISection)new SalesHistoryGUISection(this).setDisplayText(ClientReference.localize((String)"oxygen_trade.gui.trade.salesHistory", (Object[])new Object[0]))).enable();
        this.getWorkspace().initSection((AbstractGUISection)this.salesHistorySection);
    }

    protected AbstractGUISection getDefaultSection() {
        return this.buySection;
    }

    public void handleElementClick(AbstractGUISection section, GUIBaseElement element) {
    }

    protected boolean doesGUIPauseGame() {
        return false;
    }

    public void offersSynchronized() {
        this.buySection.setSearchButtonState(true);
        this.sellingSection.updateOffersAmount();
        this.offersSection.updateOffersAmount();
        this.offersSection.loadPlayerOffers();
    }

    public void salesHistorySynchronized() {
        this.salesHistorySection.enableFilterButton();
    }

    public BuyGUISection getBuySection() {
        return this.buySection;
    }

    public SellingGUISection getSellingSection() {
        return this.sellingSection;
    }

    public OffersGUISection getOffersSection() {
        return this.offersSection;
    }

    public SalesHistoryGUISection getSalesHistorySection() {
        return this.salesHistorySection;
    }

    public void updateInventoryContent() {
        this.inventoryContent.clear();
        for (ItemStack itemStack : ClientReference.getClientPlayer().field_71071_by.field_70462_a) {
            if (itemStack.func_190926_b()) continue;
            ItemStackWrapper wrapper = ItemStackWrapper.getFromStack((ItemStack)itemStack);
            if (!this.inventoryContent.containsKey(wrapper)) {
                this.inventoryContent.put(wrapper, itemStack.func_190916_E());
                continue;
            }
            int amount = this.inventoryContent.get(wrapper);
            this.inventoryContent.put(wrapper, amount += itemStack.func_190916_E());
        }
    }

    public int getEqualStackAmount(ItemStackWrapper stackWrapper) {
        int amount = 0;
        for (ItemStackWrapper wrapper : this.inventoryContent.keySet()) {
            if (!wrapper.isEquals(stackWrapper)) continue;
            amount += this.inventoryContent.get(wrapper).intValue();
        }
        return amount;
    }

    public void decrementEqualStackAmount(ItemStackWrapper stackWrapper, int value) {
        int newAmount = this.inventoryContent.get(stackWrapper) - value;
        if (newAmount == 0) {
            this.inventoryContent.remove(stackWrapper);
        } else {
            this.inventoryContent.put(stackWrapper, newAmount);
        }
    }

    public void performedOfferAction(EnumOfferAction action, PlayerOfferClient offer, long balance) {
        switch (action) {
            case PURCHASE: {
                this.buySection.itemPurchased(offer, balance);
                this.sellingSection.itemPurchased(offer, balance);
                this.offersSection.itemPurchased(offer, balance);
                break;
            }
            case CREATION: {
                this.sellingSection.offerCreated(offer, balance);
                this.buySection.offerCreated(offer, balance);
                this.offersSection.offerCreated(offer, balance);
                break;
            }
            case CANCEL: {
                this.offersSection.offerCanceled(offer, balance);
                this.buySection.offerCanceled(offer, balance);
                this.sellingSection.offerCanceled(offer, balance);
            }
        }
    }
}

