/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client.gui.trade.buy;

import austeretony.alternateui.screen.core.GUIAdvancedElement;
import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.api.ClientReference;
import austeretony.oxygen_core.client.gui.IndexedGUIButton;
import austeretony.oxygen_core.client.gui.OxygenGUITextures;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.util.OxygenUtils;
import austeretony.oxygen_trade.client.PlayerOfferClient;
import austeretony.oxygen_trade.common.config.TradeConfig;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class OfferGUIButton
extends IndexedGUIButton<Long> {
    private final ItemStack offeredStack;
    private final String playerStockStr;
    private final String amountStr;
    private final String seller;
    private final String expireTimeStr;
    private final String priceStr;
    private final String unitPriceStr;
    public final int playerStock;
    public final long price;
    private final boolean singleItem;
    private boolean overpriced;
    private boolean purchased;

    public OfferGUIButton(PlayerOfferClient offer, int playerStock, boolean overpriced) {
        super((Object)offer.getId());
        this.price = offer.getPrice();
        this.offeredStack = offer.getOfferedStack().getCachedItemStack();
        this.playerStock = playerStock;
        this.playerStockStr = String.valueOf(playerStock);
        this.amountStr = String.valueOf(offer.getAmount());
        this.seller = ClientReference.localize((String)"oxygen_trade.gui.trade.seller", (Object[])new Object[]{offer.getUsername()});
        this.expireTimeStr = OxygenUtils.getExpirationTimeLocalizedString((long)((long)TradeConfig.OFFER_EXPIRE_TIME_HOURS.getIntValue() * 3600000L), (long)offer.getId());
        this.priceStr = OxygenUtils.formatCurrencyValue((String)String.valueOf(offer.getPrice()));
        this.unitPriceStr = OxygenUtils.formatCurrencyValue((String)String.valueOf(offer.getPrice() / (long)offer.getAmount()));
        this.singleItem = offer.getAmount() == 1;
        this.overpriced = overpriced;
        this.requireDoubleClick();
        this.setDisplayText(this.offeredStack.func_82833_r());
        this.setStaticBackgroundColor(GUISettings.get().getActiveElementColorTransparent());
        this.setDynamicBackgroundColor(GUISettings.get().getEnabledElementColor(), GUISettings.get().getDisabledElementColor(), GUISettings.get().getHoveredElementColor());
        this.setTextDynamicColor(GUISettings.get().getEnabledTextColor(), GUISettings.get().getDisabledTextColor(), GUISettings.get().getHoveredTextColor());
    }

    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179126_j();
            this.itemRender.func_180450_b(this.offeredStack, this.getX() + 2, this.getY());
            GlStateManager.func_179097_i();
            RenderHelper.func_74518_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = this.getEnabledBackgroundColor();
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
            } else if (this.isHovered()) {
                color = this.getHoveredBackgroundColor();
            }
            if (this.purchased) {
                color = this.getStaticBackgroundColor();
            }
            int third = this.getWidth() / 3;
            CustomRectUtils.drawGradientRect((double)0.0, (double)0.0, (double)third, (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.RIGHT);
            OfferGUIButton.drawRect((int)third, (int)0, (int)(this.getWidth() - third), (int)this.getHeight(), (int)color);
            CustomRectUtils.drawGradientRect((double)(this.getWidth() - third), (double)0.0, (double)this.getWidth(), (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.LEFT);
            color = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                color = this.getDisabledTextColor();
            } else if (this.isHovered()) {
                color = this.getHoveredTextColor();
            }
            float textScale = GUISettings.get().getSubTextScale() - 0.05f;
            if (this.isHovered()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)16.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
                this.mc.field_71466_p.func_175065_a(this.playerStockStr, 0.0f, 0.0f, color, true);
                GlStateManager.func_179121_F();
            }
            if (!this.singleItem) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)16.0f, (float)10.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
                this.mc.field_71466_p.func_175065_a(this.amountStr, 0.0f, 0.0f, color, true);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.getWidth() - 12.0f - (float)this.textWidth(this.priceStr, textScale)), (float)2.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.priceStr, 0.0f, 0.0f, !this.overpriced ? color : GUISettings.get().getInactiveElementColor(), false);
            GlStateManager.func_179121_F();
            if (!this.singleItem) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)this.getWidth() - 12.0f - (float)this.textWidth(this.unitPriceStr, textScale - 0.05f)), (float)10.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(textScale - 0.05f), (float)(textScale - 0.05f), (float)0.0f);
                this.mc.field_71466_p.func_175065_a(this.unitPriceStr, 0.0f, 0.0f, color, false);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)34.0f, (float)10.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.seller, 0.0f, 0.0f, GUISettings.get().getEnabledTextColorDark(), false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.getWidth() - 74.0f), (float)((float)(this.getHeight() - this.textHeight(textScale)) / 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.expireTimeStr, 0.0f, 0.0f, color, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)30.0f, (float)2.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(textScale + 0.1f), (float)(textScale + 0.1f), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, !this.overpriced ? color : GUISettings.get().getInactiveElementColor(), false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            this.mc.func_110434_K().func_110577_a(OxygenGUITextures.COIN_ICON);
            GUIAdvancedElement.drawCustomSizedTexturedRect((int)(this.getWidth() - 10), (int)1, (int)0, (int)0, (int)6, (int)6, (int)6, (int)6);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    public void drawTooltip(int mouseX, int mouseY) {
        if (mouseX >= this.getX() + 2 && mouseY >= this.getY() && mouseX < this.getX() + 18 && mouseY < this.getY() + this.getHeight()) {
            this.screen.drawToolTip(this.offeredStack, mouseX + 6, mouseY);
        }
    }

    public ItemStack getOfferedStack() {
        return this.offeredStack;
    }

    public void setOverpriced() {
        this.overpriced = true;
    }

    public boolean isOverpriced() {
        return this.overpriced;
    }

    public void setPurchased() {
        this.purchased = true;
    }

    public boolean isPurchased() {
        return this.purchased;
    }
}

