/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.client.gui.trade.selling;

import austeretony.alternateui.util.EnumGUIAlignment;
import austeretony.oxygen_core.client.gui.IndexedGUIButton;
import austeretony.oxygen_core.client.gui.elements.CustomRectUtils;
import austeretony.oxygen_core.client.gui.settings.GUISettings;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class InventoryItemGUIButton
extends IndexedGUIButton<ItemStack> {
    public final ItemStackWrapper stackWrapper;
    private String playerStockStr;
    private int playerStock;
    private boolean singleItem;

    public InventoryItemGUIButton(ItemStackWrapper stackWrapper, int playerStock) {
        super((Object)stackWrapper.getCachedItemStack());
        this.stackWrapper = stackWrapper;
        this.playerStock = playerStock;
        this.playerStockStr = String.valueOf(playerStock);
        this.singleItem = playerStock == 1;
        this.requireDoubleClick();
        this.setDisplayText(((ItemStack)this.index).func_82833_r());
        this.setDynamicBackgroundColor(GUISettings.get().getEnabledElementColor(), GUISettings.get().getDisabledElementColor(), GUISettings.get().getHoveredElementColor());
        this.setTextDynamicColor(GUISettings.get().getEnabledTextColor(), GUISettings.get().getDisabledTextColor(), GUISettings.get().getHoveredTextColor());
    }

    public void draw(int mouseX, int mouseY) {
        if (this.isVisible()) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179126_j();
            this.itemRender.func_180450_b((ItemStack)this.index, this.getX() + 2, this.getY());
            GlStateManager.func_179097_i();
            RenderHelper.func_74518_a();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
            GlStateManager.func_179152_a((float)this.getScale(), (float)this.getScale(), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int color = this.getEnabledBackgroundColor();
            if (!this.isEnabled()) {
                color = this.getDisabledBackgroundColor();
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredBackgroundColor();
            }
            int third = this.getWidth() / 3;
            CustomRectUtils.drawGradientRect((double)0.0, (double)0.0, (double)third, (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.RIGHT);
            InventoryItemGUIButton.drawRect((int)third, (int)0, (int)(this.getWidth() - third), (int)this.getHeight(), (int)color);
            CustomRectUtils.drawGradientRect((double)(this.getWidth() - third), (double)0.0, (double)this.getWidth(), (double)this.getHeight(), (int)0, (int)color, (EnumGUIAlignment)EnumGUIAlignment.LEFT);
            color = this.getEnabledTextColor();
            if (!this.isEnabled()) {
                color = this.getDisabledTextColor();
            } else if (this.isHovered() || this.isToggled()) {
                color = this.getHoveredTextColor();
            }
            float textScale = GUISettings.get().getSubTextScale() - 0.05f;
            if (!this.singleItem) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)16.0f, (float)10.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)0.0f);
                this.mc.field_71466_p.func_175065_a(this.playerStockStr, 0.0f, 0.0f, color, true);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)30.0f, (float)((float)(this.getHeight() - this.textHeight(textScale)) / 2.0f), (float)0.0f);
            GlStateManager.func_179152_a((float)(textScale + 0.1f), (float)(textScale + 0.1f), (float)0.0f);
            this.mc.field_71466_p.func_175065_a(this.getDisplayText(), 0.0f, 0.0f, color, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }

    public void drawTooltip(int mouseX, int mouseY) {
        if (mouseX >= this.getX() + 2 && mouseY >= this.getY() && mouseX < this.getX() + 18 && mouseY < this.getY() + this.getHeight()) {
            this.screen.drawToolTip((ItemStack)this.index, mouseX + 6, mouseY);
        }
    }

    public int getPlayerStock() {
        return this.playerStock;
    }

    public void decrementPlayerStock(int value) {
        this.setPlayerStock(this.playerStock - value);
    }

    public void setPlayerStock(int stock) {
        this.playerStock = stock;
        this.playerStockStr = String.valueOf(stock);
    }
}

