/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.common.main;

import austeretony.oxygen_core.client.api.OxygenGUIHelper;
import austeretony.oxygen_core.client.api.OxygenHelperClient;
import austeretony.oxygen_core.client.command.CommandOxygenClient;
import austeretony.oxygen_core.client.gui.menu.OxygenMenuEntry;
import austeretony.oxygen_core.client.sync.DataSyncHandlerClient;
import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.api.OxygenHelperCommon;
import austeretony.oxygen_core.common.command.ArgumentExecutor;
import austeretony.oxygen_core.common.config.ConfigHolder;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.privilege.Privilege;
import austeretony.oxygen_core.common.privilege.PrivilegeImpl;
import austeretony.oxygen_core.common.privilege.PrivilegedGroupImpl;
import austeretony.oxygen_core.common.status.ChatMessagesHandler;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegeProviderServer;
import austeretony.oxygen_core.server.api.RequestsFilterHelper;
import austeretony.oxygen_core.server.preset.PresetServer;
import austeretony.oxygen_core.server.sync.DataSyncHandlerServer;
import austeretony.oxygen_mail.common.main.EnumMailPrivilege;
import austeretony.oxygen_trade.client.OffersSyncHandlerClient;
import austeretony.oxygen_trade.client.SalesHistorySyncHandlerClient;
import austeretony.oxygen_trade.client.TradeManagerClient;
import austeretony.oxygen_trade.client.TradeStatusMessagesHandler;
import austeretony.oxygen_trade.client.command.TradeArgumentExecutorClient;
import austeretony.oxygen_trade.client.event.TradeEventsClient;
import austeretony.oxygen_trade.client.gui.trade.TradeMenuGUIScreen;
import austeretony.oxygen_trade.client.input.TradeKeyHandler;
import austeretony.oxygen_trade.common.config.TradeConfig;
import austeretony.oxygen_trade.common.main.EnumTradePrivilege;
import austeretony.oxygen_trade.common.network.client.CPOfferAction;
import austeretony.oxygen_trade.common.network.server.SPCreateOffer;
import austeretony.oxygen_trade.common.network.server.SPPurchaseOrCancelOffer;
import austeretony.oxygen_trade.server.OffersSyncHandlerServer;
import austeretony.oxygen_trade.server.SalesHistorySyncHandlerServer;
import austeretony.oxygen_trade.server.TradeManagerServer;
import austeretony.oxygen_trade.server.category.ItemCategoriesPresetServer;
import austeretony.oxygen_trade.server.event.TradeEventsServer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="oxygen_trade", name="Oxygen: Trade", version="0.9.1", dependencies="required-after:oxygen_core@[0.9.0,);required-after:oxygen_mail@[0.9.0,);", certificateFingerprint="503a793335572ddd78512349bd8048f536a62fdb", updateJSON="https://raw.githubusercontent.com/AustereTony-MCMods/Oxygen-Trade/info/mod_versions_forge.json", acceptedMinecraftVersions="[1.12.2]")
public class TradeMain {
    public static final String MODID = "oxygen_trade";
    public static final String NAME = "Oxygen: Trade";
    public static final String VERSION = "0.9.1";
    public static final String VERSION_CUSTOM = "0.9.1:beta:0";
    public static final String GAME_VERSION = "1.12.2";
    public static final String VERSIONS_FORGE_URL = "https://raw.githubusercontent.com/AustereTony-MCMods/Oxygen-Trade/info/mod_versions_forge.json";
    public static final int TRADE_MOD_INDEX = 10;
    public static final int OFFERS_DATA_ID = 100;
    public static final int SALES_HISTORY_DATA_ID = 101;
    public static final int ITEM_CATEGORIES_PRESET_ID = 100;
    public static final int TRADE_MENU_SCREEN_ID = 100;
    public static final int CREATE_OFFER_REQUEST_ID = 105;
    public static final int PURCHASE_OR_CANCEL_REQUEST_ID = 106;
    public static final Logger LOGGER = LogManager.getLogger((String)"Oxygen: Trade");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        OxygenHelperCommon.registerConfig((ConfigHolder)new TradeConfig());
        if (event.getSide() == Side.CLIENT) {
            CommandOxygenClient.registerArgumentExecutor((ArgumentExecutor)new TradeArgumentExecutorClient("trade", true));
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.initNetwork();
        TradeManagerServer.create();
        CommonReference.registerEvent((Object)new TradeEventsServer());
        OxygenHelperServer.registerDataSyncHandler((DataSyncHandlerServer)new OffersSyncHandlerServer());
        OxygenHelperServer.registerDataSyncHandler((DataSyncHandlerServer)new SalesHistorySyncHandlerServer());
        OxygenHelperServer.registerPreset((PresetServer)new ItemCategoriesPresetServer());
        RequestsFilterHelper.registerNetworkRequest((int)105, (int)1);
        RequestsFilterHelper.registerNetworkRequest((int)106, (int)1);
        if (event.getSide() == Side.CLIENT) {
            TradeManagerClient.create();
            CommonReference.registerEvent((Object)new TradeEventsClient());
            if (!OxygenGUIHelper.isOxygenMenuEnabled()) {
                CommonReference.registerEvent((Object)new TradeKeyHandler());
            }
            OxygenGUIHelper.registerOxygenMenuEntry((OxygenMenuEntry)TradeMenuGUIScreen.TRADE_MENU_ENTRY);
            OxygenHelperClient.registerStatusMessagesHandler((ChatMessagesHandler)new TradeStatusMessagesHandler());
            OxygenHelperClient.registerDataSyncHandler((DataSyncHandlerClient)new OffersSyncHandlerClient());
            OxygenHelperClient.registerDataSyncHandler((DataSyncHandlerClient)new SalesHistorySyncHandlerClient());
        }
        EnumTradePrivilege.register();
    }

    public static void addDefaultPrivileges() {
        if (!PrivilegeProviderServer.getGroup((String)PrivilegedGroupImpl.OPERATORS_GROUP.groupName).hasPrivilege(EnumMailPrivilege.MAILBOX_SIZE.toString())) {
            PrivilegeProviderServer.addPrivileges((String)PrivilegedGroupImpl.OPERATORS_GROUP.groupName, (boolean)true, (Privilege[])new Privilege[]{new PrivilegeImpl(EnumTradePrivilege.ITEMS_PER_OFFER_MAX_AMOUNT.toString(), 1000), new PrivilegeImpl(EnumTradePrivilege.PRICE_MAX_VALUE.toString(), 1000000L)});
            LOGGER.info("Default <{}> group privileges added.", (Object)PrivilegedGroupImpl.OPERATORS_GROUP.groupName);
        }
    }

    private void initNetwork() {
        OxygenMain.network().registerPacket(CPOfferAction.class);
        OxygenMain.network().registerPacket(SPCreateOffer.class);
        OxygenMain.network().registerPacket(SPPurchaseOrCancelOffer.class);
    }
}

