/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.RequestsFilterHelper;
import austeretony.oxygen_trade.server.TradeManagerServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPCreateOffer
extends Packet {
    private ItemStackWrapper stackWrapper;
    private int amount;
    private long price;

    public SPCreateOffer() {
    }

    public SPCreateOffer(ItemStackWrapper stackWrapper, int amount, long price) {
        this.stackWrapper = stackWrapper;
        this.amount = amount;
        this.price = price;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        this.stackWrapper.write(buffer);
        buffer.writeShort(this.amount);
        buffer.writeLong(this.price);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        EntityPlayerMP playerMP = SPCreateOffer.getEntityPlayerMP((INetHandler)netHandler);
        if (RequestsFilterHelper.getLock((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)105)) {
            ItemStackWrapper stackWrapper = ItemStackWrapper.read((ByteBuf)buffer);
            short amount = buffer.readShort();
            long price = buffer.readLong();
            OxygenHelperServer.addRoutineTask(() -> TradeManagerServer.instance().getOffersManager().createOffer(playerMP, stackWrapper, amount, price));
        }
    }
}

