/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.common.network.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.RequestsFilterHelper;
import austeretony.oxygen_trade.common.main.EnumOfferAction;
import austeretony.oxygen_trade.server.TradeManagerServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;

public class SPPurchaseOrCancelOffer
extends Packet {
    private int ordinal;
    private long offerId;

    public SPPurchaseOrCancelOffer() {
    }

    public SPPurchaseOrCancelOffer(EnumOfferAction action, long offerId) {
        this.ordinal = action.ordinal();
        this.offerId = offerId;
    }

    public void write(ByteBuf buffer, INetHandler netHandler) {
        buffer.writeByte(this.ordinal);
        buffer.writeLong(this.offerId);
    }

    public void read(ByteBuf buffer, INetHandler netHandler) {
        EntityPlayerMP playerMP = SPPurchaseOrCancelOffer.getEntityPlayerMP((INetHandler)netHandler);
        if (RequestsFilterHelper.getLock((UUID)CommonReference.getPersistentUUID((Entity)playerMP), (int)106)) {
            byte ordinal = buffer.readByte();
            long offerId = buffer.readLong();
            if (ordinal >= 0 && ordinal < EnumOfferAction.values().length) {
                switch (EnumOfferAction.values()[ordinal]) {
                    case PURCHASE: {
                        OxygenHelperServer.addRoutineTask(() -> TradeManagerServer.instance().getOffersManager().purchaseItem(playerMP, offerId));
                        break;
                    }
                    case CANCEL: {
                        OxygenHelperServer.addRoutineTask(() -> TradeManagerServer.instance().getOffersManager().cancelOffer(playerMP, offerId));
                        break;
                    }
                }
            }
        }
    }
}

