/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.server;

import austeretony.oxygen_core.common.persistent.AbstractPersistentData;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_trade.common.config.TradeConfig;
import austeretony.oxygen_trade.common.main.TradeMain;
import austeretony.oxygen_trade.server.PlayerOfferServer;
import austeretony.oxygen_trade.server.TradeManagerServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OffersContainerServer
extends AbstractPersistentData {
    private final Map<Long, PlayerOfferServer> offers = new ConcurrentHashMap<Long, PlayerOfferServer>();

    public int getOffersAmount() {
        return this.offers.size();
    }

    public Set<Long> getOfferIds() {
        return this.offers.keySet();
    }

    public Collection<PlayerOfferServer> getOffers() {
        return this.offers.values();
    }

    public boolean isOfferExist(long offerId) {
        return this.offers.containsKey(offerId);
    }

    public PlayerOfferServer getOffer(long offerId) {
        return this.offers.get(offerId);
    }

    public void addOffer(PlayerOfferServer offer) {
        offer.updateOwnerUsername();
        this.offers.put(offer.getId(), offer);
    }

    public void removeOffer(long offerId) {
        this.offers.remove(offerId);
    }

    public String getDisplayName() {
        return "offers_data";
    }

    public String getPath() {
        return OxygenHelperServer.getDataFolder() + "/server/world/trade/offers_server.dat";
    }

    public long getSaveDelayMinutes() {
        return TradeConfig.DATA_SAVE_DELAY_MINUTES.getIntValue();
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((int)this.offers.size(), (OutputStream)bos);
        for (PlayerOfferServer offer : this.offers.values()) {
            offer.write(bos);
        }
    }

    public void read(BufferedInputStream bis) throws IOException {
        int amount = StreamUtils.readInt((InputStream)bis);
        for (int i = 0; i < amount; ++i) {
            PlayerOfferServer offer = new PlayerOfferServer();
            offer.read(bis);
            this.addOffer(offer);
        }
        TradeMain.LOGGER.info("Loaded {} trade offers.", (Object)this.getOffersAmount());
        TradeManagerServer.instance().getOffersManager().processExpiredOffers();
    }

    public void reset() {
        this.offers.clear();
    }
}

