/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.currency.CurrencyHelperServer;
import austeretony.oxygen_core.common.inventory.InventoryHelper;
import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.server.OxygenManagerServer;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.PrivilegeProviderServer;
import austeretony.oxygen_core.server.api.SoundEventHelperServer;
import austeretony.oxygen_core.server.api.WatcherHelperServer;
import austeretony.oxygen_mail.common.Parcel;
import austeretony.oxygen_mail.server.api.MailHelperServer;
import austeretony.oxygen_trade.common.config.TradeConfig;
import austeretony.oxygen_trade.common.main.EnumOfferAction;
import austeretony.oxygen_trade.common.main.EnumTradePrivilege;
import austeretony.oxygen_trade.common.main.EnumTradeStatusMessage;
import austeretony.oxygen_trade.common.main.TradeMain;
import austeretony.oxygen_trade.common.network.client.CPOfferAction;
import austeretony.oxygen_trade.server.PlayerOfferServer;
import austeretony.oxygen_trade.server.QueuedOfferActionServer;
import austeretony.oxygen_trade.server.QueuedOfferCreation;
import austeretony.oxygen_trade.server.SalesHistoryEntryServer;
import austeretony.oxygen_trade.server.TradeManagerServer;
import java.util.Iterator;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class OffersManagerServer {
    private final TradeManagerServer manager;
    private final Queue<QueuedOfferCreation> offerCreationQueue = new ConcurrentLinkedQueue<QueuedOfferCreation>();
    private final Queue<QueuedOfferActionServer> offerActionsQueue = new ConcurrentLinkedQueue<QueuedOfferActionServer>();

    public OffersManagerServer(TradeManagerServer manager) {
        this.manager = manager;
        OxygenManagerServer.instance().getExecutionManager().getExecutors().getSchedulerExecutorService().scheduleAtFixedRate(() -> {
            this.processOfferCreationQueue();
            this.processOfferActionsQueue();
        }, 1000L, 250L, TimeUnit.MILLISECONDS);
    }

    public void informPlayer(EntityPlayerMP playerMP, EnumTradeStatusMessage status) {
        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)playerMP, (int)10, (int)status.ordinal());
    }

    public void processExpiredOffers() {
        OxygenHelperServer.addRoutineTask(() -> {
            if (this.manager.getOffersContainer().getOffersAmount() > 0) {
                Iterator<PlayerOfferServer> iterator = this.manager.getOffersContainer().getOffers().iterator();
                long currTimeMillis = System.currentTimeMillis();
                long expireTimeMillis = (long)TradeConfig.OFFER_EXPIRE_TIME_HOURS.getIntValue() * 3600000L;
                int removed = 0;
                while (iterator.hasNext()) {
                    PlayerOfferServer offer = iterator.next();
                    if (currTimeMillis - offer.getId() <= expireTimeMillis) continue;
                    iterator.remove();
                    this.returnItemToSeller(offer);
                    ++removed;
                }
                if (removed > 0) {
                    this.manager.getOffersContainer().setChanged(true);
                }
                TradeMain.LOGGER.info("Removed {} expired offers.", (Object)removed);
            }
        });
    }

    private void returnExpiredItemToSeller(PlayerOfferServer offer) {
        MailHelperServer.sendSystemPackage((UUID)offer.getPlayerUUID(), (String)"mail.sender.sys", (String)"trade.expired", (String)"trade.expiredOfferMessage", (Parcel)Parcel.create((ItemStackWrapper)offer.getOfferedStack(), (int)offer.getAmount()));
    }

    public int getPlayerOffersAmount(UUID playerUUID) {
        int amount = 0;
        for (PlayerOfferServer offer : this.manager.getOffersContainer().getOffers()) {
            if (!offer.getPlayerUUID().equals(playerUUID)) continue;
            ++amount;
        }
        return amount;
    }

    public boolean canCreateOffer(UUID playerUUID) {
        return this.getPlayerOffersAmount(playerUUID) < PrivilegeProviderServer.getValue((UUID)playerUUID, (String)EnumTradePrivilege.MAX_OFFERS_PER_PLAYER.toString(), (int)TradeConfig.MAX_OFFERS_PER_PLAYER.getIntValue());
    }

    public void createOffer(EntityPlayerMP playerMP, ItemStackWrapper stackWrapper, int amount, long price) {
        this.offerCreationQueue.offer(new QueuedOfferCreation(CommonReference.getPersistentUUID((Entity)playerMP), stackWrapper, amount, price));
    }

    private void processOfferCreationQueue() {
        while (!this.offerCreationQueue.isEmpty()) {
            QueuedOfferCreation creation = this.offerCreationQueue.poll();
            EntityPlayerMP playerMP = CommonReference.playerByUUID((UUID)creation.playerUUID);
            if (playerMP == null) continue;
            OxygenHelperServer.addRoutineTask(() -> {
                if (this.tryToCreateOffer(playerMP, creation.playerUUID, creation.stackWrapper, creation.amount, creation.price)) {
                    this.informPlayer(playerMP, EnumTradeStatusMessage.OFFER_CREATED);
                } else {
                    this.informPlayer(playerMP, EnumTradeStatusMessage.OFFER_CREATION_FAILED);
                }
            });
        }
    }

    private boolean tryToCreateOffer(EntityPlayerMP playerMP, UUID playerUUID, ItemStackWrapper stackWrapper, int amount, long price) {
        int maxAmount = PrivilegeProviderServer.getValue((UUID)playerUUID, (String)EnumTradePrivilege.ITEMS_PER_OFFER_MAX_AMOUNT.toString(), (int)TradeConfig.ITEMS_PER_OFFER_MAX_AMOUNT.getIntValue());
        if (maxAmount < 0) {
            maxAmount = stackWrapper.getItemStack().func_77976_d();
        }
        long maxPrice = PrivilegeProviderServer.getValue((UUID)playerUUID, (String)EnumTradePrivilege.PRICE_MAX_VALUE.toString(), (long)TradeConfig.PRICE_MAX_VALUE.getLongValue());
        if (this.validateItem(playerMP, stackWrapper) && amount > 0 && amount <= maxAmount && price > 0L && price <= maxPrice && this.canCreateOffer(playerUUID)) {
            boolean feeExist;
            long offerCreationFee = MathUtils.percentValueOf((long)price, (int)PrivilegeProviderServer.getValue((UUID)playerUUID, (String)EnumTradePrivilege.OFFER_CREATION_FEE_PERCENT.toString(), (int)TradeConfig.OFFER_CREATION_FEE_PERCENT.getIntValue()));
            boolean bl = feeExist = offerCreationFee > 0L;
            if (InventoryHelper.getEqualStackAmount((EntityPlayer)playerMP, (ItemStackWrapper)stackWrapper) >= amount && (feeExist || CurrencyHelperServer.enoughCurrency((UUID)playerUUID, (long)offerCreationFee))) {
                CommonReference.delegateToServerThread(() -> InventoryHelper.removeEqualStack((EntityPlayer)playerMP, (ItemStackWrapper)stackWrapper, (int)amount));
                if (feeExist) {
                    CurrencyHelperServer.removeCurrency((UUID)playerUUID, (long)offerCreationFee);
                    CurrencyHelperServer.save((UUID)playerUUID);
                    WatcherHelperServer.setValue((UUID)playerUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)playerUUID));
                    SoundEventHelperServer.playSoundClient((EntityPlayerMP)playerMP, (int)OxygenSoundEffects.SELL.id);
                }
                PlayerOfferServer offer = new PlayerOfferServer(this.createOfferId(), playerUUID, stackWrapper, amount, price);
                this.addOffer(offer);
                OxygenMain.network().sendTo((Packet)new CPOfferAction(EnumOfferAction.CREATION, offer, CurrencyHelperServer.getCurrency((UUID)playerUUID)), playerMP);
                return true;
            }
        }
        return false;
    }

    private boolean validateItem(EntityPlayerMP playerMP, ItemStackWrapper stackWrapper) {
        if (stackWrapper.itemId == Item.func_150891_b((Item)Items.field_190931_a)) {
            this.informPlayer(playerMP, EnumTradeStatusMessage.ITEM_DAMAGED);
            return false;
        }
        if (this.manager.getItemsBlackList().isBlackListed(Item.func_150899_d((int)stackWrapper.itemId))) {
            this.informPlayer(playerMP, EnumTradeStatusMessage.ITEM_BLACKLISTED);
            return false;
        }
        return true;
    }

    private void addOffer(PlayerOfferServer offer) {
        this.manager.getOffersContainer().addOffer(offer);
        this.manager.getOffersContainer().setChanged(true);
    }

    private long createOfferId() {
        long id = System.currentTimeMillis();
        while (this.manager.getOffersContainer().isOfferExist(id)) {
            ++id;
        }
        return id;
    }

    public void purchaseItem(EntityPlayerMP playerMP, long offerId) {
        this.offerActionsQueue.offer(new QueuedOfferActionServer(CommonReference.getPersistentUUID((Entity)playerMP), EnumOfferAction.PURCHASE, offerId));
    }

    public void cancelOffer(EntityPlayerMP playerMP, long offerId) {
        this.offerActionsQueue.offer(new QueuedOfferActionServer(CommonReference.getPersistentUUID((Entity)playerMP), EnumOfferAction.CANCEL, offerId));
    }

    private void processOfferActionsQueue() {
        while (!this.offerActionsQueue.isEmpty()) {
            QueuedOfferActionServer action = this.offerActionsQueue.poll();
            EntityPlayerMP playerMP = CommonReference.playerByUUID((UUID)action.playerUUID);
            if (playerMP == null) continue;
            OxygenHelperServer.addRoutineTask(() -> this.processOfferAction(playerMP, action.action, action.offerId));
        }
    }

    private void processOfferAction(EntityPlayerMP playerMP, EnumOfferAction action, long offerId) {
        switch (action) {
            case PURCHASE: {
                this.purchase(playerMP, offerId);
                break;
            }
            case CANCEL: {
                this.cancel(playerMP, offerId);
                break;
            }
        }
    }

    private void purchase(EntityPlayerMP playerMP, long offerId) {
        if (this.tryToPurchaseItem(playerMP, offerId)) {
            this.informPlayer(playerMP, EnumTradeStatusMessage.ITEM_PURCHASED);
        } else {
            this.informPlayer(playerMP, EnumTradeStatusMessage.ITEM_PURCHASE_FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToPurchaseItem(EntityPlayerMP playerMP, long offerId) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (this.manager.getOffersContainer().isOfferExist(offerId)) {
            PlayerOfferServer offer;
            PlayerOfferServer playerOfferServer = offer = this.manager.getOffersContainer().getOffer(offerId);
            synchronized (playerOfferServer) {
                if (this.manager.getOffersContainer().isOfferExist(offerId)) {
                    ItemStack itemStack = offer.getOfferedStack().getItemStack();
                    if (InventoryHelper.haveEnoughSpace((EntityPlayer)playerMP, (int)offer.getAmount(), (int)itemStack.func_77976_d()) && CurrencyHelperServer.enoughCurrency((UUID)playerUUID, (long)offer.getPrice())) {
                        CurrencyHelperServer.removeCurrency((UUID)playerUUID, (long)offer.getPrice());
                        CurrencyHelperServer.save((UUID)playerUUID);
                        WatcherHelperServer.setValue((UUID)playerUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)playerUUID));
                        SoundEventHelperServer.playSoundClient((EntityPlayerMP)playerMP, (int)OxygenSoundEffects.SELL.id);
                        this.removeOffer(offerId);
                        this.addSalesHsistoryRecord(offer, playerUUID);
                        this.sendItemToBuyer(playerUUID, offer);
                        this.sendSaleIncomeToSeller(offer);
                        OxygenMain.network().sendTo((Packet)new CPOfferAction(EnumOfferAction.PURCHASE, offer, CurrencyHelperServer.getCurrency((UUID)playerUUID)), playerMP);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void removeOffer(long offerId) {
        this.manager.getOffersContainer().removeOffer(offerId);
        this.manager.getOffersContainer().setChanged(true);
    }

    private void addSalesHsistoryRecord(PlayerOfferServer offer, UUID buyerUUID) {
        if (TradeConfig.ENABLE_SALES_HISTORY.getBooleanValue()) {
            this.manager.getSalesHistoryContainer().addEntry(SalesHistoryEntryServer.fromOffer(offer, buyerUUID));
            this.manager.getSalesHistoryContainer().setChanged(true);
        }
    }

    private void sendItemToBuyer(UUID buyerUUID, PlayerOfferServer offer) {
        MailHelperServer.sendSystemPackage((UUID)buyerUUID, (String)"mail.sender.sys", (String)"trade.purchased", (String)"trade.purchasedItemMessage", (Parcel)Parcel.create((ItemStackWrapper)offer.getOfferedStack(), (int)offer.getAmount()));
    }

    private void sendSaleIncomeToSeller(PlayerOfferServer offer) {
        long saleFee = MathUtils.percentValueOf((long)offer.getPrice(), (int)PrivilegeProviderServer.getValue((UUID)offer.getPlayerUUID(), (String)EnumTradePrivilege.OFFER_SALE_FEE_PERCENT.toString(), (int)TradeConfig.OFFER_SALE_FEE_PERCENT.getIntValue()));
        MailHelperServer.sendSystemRemittance((UUID)offer.getPlayerUUID(), (String)"mail.sender.sys", (String)"trade.sold", (String)"trade.soldItemMessage", (long)(offer.getPrice() - saleFee));
    }

    public void cancel(EntityPlayerMP playerMP, long offerId) {
        if (this.tryToCancelOffer(playerMP, offerId)) {
            this.informPlayer(playerMP, EnumTradeStatusMessage.OFFER_CANCELED);
        } else {
            this.informPlayer(playerMP, EnumTradeStatusMessage.OFFER_CANCELLATION_FAILED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryToCancelOffer(EntityPlayerMP playerMP, long offerId) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)playerMP);
        if (this.manager.getOffersContainer().isOfferExist(offerId)) {
            PlayerOfferServer offer;
            PlayerOfferServer playerOfferServer = offer = this.manager.getOffersContainer().getOffer(offerId);
            synchronized (playerOfferServer) {
                if (this.manager.getOffersContainer().isOfferExist(offerId) && offer.isOwner(playerUUID)) {
                    this.removeOffer(offerId);
                    this.returnItemToSeller(offer);
                    OxygenMain.network().sendTo((Packet)new CPOfferAction(EnumOfferAction.CANCEL, offer, CurrencyHelperServer.getCurrency((UUID)playerUUID)), playerMP);
                    return true;
                }
            }
        }
        return false;
    }

    private void returnItemToSeller(PlayerOfferServer offer) {
        MailHelperServer.sendSystemPackage((UUID)offer.getPlayerUUID(), (String)"mail.sender.sys", (String)"trade.cancel", (String)"trade.cancelOfferMessage", (Parcel)Parcel.create((ItemStackWrapper)offer.getOfferedStack(), (int)offer.getAmount()));
    }
}

