/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.server;

import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.persistent.PersistentEntry;
import austeretony.oxygen_core.common.sync.SynchronizedData;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class PlayerOfferServer
implements PersistentEntry,
SynchronizedData {
    private long offerId;
    private long price;
    private UUID playerUUID;
    private ItemStackWrapper offeredStack;
    private int amount;
    private String username;

    public PlayerOfferServer() {
    }

    public PlayerOfferServer(long offerId, UUID playerUUID, ItemStackWrapper offeredStack, int amount, long price) {
        this.offerId = offerId;
        this.playerUUID = playerUUID;
        this.offeredStack = offeredStack;
        this.amount = amount;
        this.price = price;
    }

    public long getId() {
        return this.offerId;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public ItemStackWrapper getOfferedStack() {
        return this.offeredStack;
    }

    public int getAmount() {
        return this.amount;
    }

    public long getPrice() {
        return this.price;
    }

    public void updateOwnerUsername() {
        this.username = OxygenHelperServer.getPlayerSharedData((UUID)this.playerUUID).getUsername();
    }

    public boolean isOwner(UUID playerUUID) {
        return this.playerUUID.equals(playerUUID);
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((long)this.offerId, (OutputStream)bos);
        StreamUtils.write((UUID)this.playerUUID, (OutputStream)bos);
        this.offeredStack.write(bos);
        StreamUtils.write((short)((short)this.amount), (OutputStream)bos);
        StreamUtils.write((long)this.price, (OutputStream)bos);
    }

    public void read(BufferedInputStream bis) throws IOException {
        this.offerId = StreamUtils.readLong((InputStream)bis);
        this.playerUUID = StreamUtils.readUUID((InputStream)bis);
        this.offeredStack = ItemStackWrapper.read((BufferedInputStream)bis);
        this.amount = StreamUtils.readShort((InputStream)bis);
        this.price = StreamUtils.readLong((InputStream)bis);
    }

    public void write(ByteBuf buffer) {
        buffer.writeLong(this.offerId);
        ByteBufUtils.writeString((String)this.username, (ByteBuf)buffer);
        this.offeredStack.write(buffer);
        buffer.writeShort(this.amount);
        buffer.writeLong(this.price);
    }

    public void read(ByteBuf buffer) {
    }
}

