/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.server;

import austeretony.oxygen_core.common.item.ItemStackWrapper;
import austeretony.oxygen_core.common.persistent.PersistentEntry;
import austeretony.oxygen_core.common.sync.SynchronizedData;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.common.util.StreamUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_trade.server.PlayerOfferServer;
import austeretony.oxygen_trade.server.TradeManagerServer;
import io.netty.buffer.ByteBuf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class SalesHistoryEntryServer
implements PersistentEntry,
SynchronizedData {
    private long entryId;
    private long price;
    private UUID sellerUUID;
    private UUID buyerUUID;
    private ItemStackWrapper offeredStack;
    private int amount;
    private String sellerUsername;
    private String buyerUsername;

    public SalesHistoryEntryServer() {
    }

    private SalesHistoryEntryServer(long entryId, UUID ownerUUID, UUID buyerUUID, ItemStackWrapper offeredStack, int amount, long price) {
        this.entryId = entryId;
        this.sellerUUID = ownerUUID;
        this.buyerUUID = buyerUUID;
        this.offeredStack = offeredStack;
        this.amount = amount;
        this.price = price;
    }

    public static SalesHistoryEntryServer fromOffer(PlayerOfferServer offer, UUID buyerUUID) {
        long id = System.currentTimeMillis();
        while (TradeManagerServer.instance().getSalesHistoryContainer().isEntryExist(id)) {
            ++id;
        }
        return new SalesHistoryEntryServer(id, offer.getPlayerUUID(), buyerUUID, offer.getOfferedStack(), offer.getAmount(), offer.getPrice());
    }

    public long getId() {
        return this.entryId;
    }

    public UUID getSellerUUID() {
        return this.sellerUUID;
    }

    public UUID getBuyerUUID() {
        return this.buyerUUID;
    }

    public ItemStackWrapper getOfferedStack() {
        return this.offeredStack;
    }

    public int getAmount() {
        return this.amount;
    }

    public long getPrice() {
        return this.price;
    }

    public void updateSellerUsername() {
        this.sellerUsername = OxygenHelperServer.getPlayerSharedData((UUID)this.sellerUUID).getUsername();
    }

    public void updateBuyerUsername() {
        this.buyerUsername = OxygenHelperServer.getPlayerSharedData((UUID)this.buyerUUID).getUsername();
    }

    public void write(BufferedOutputStream bos) throws IOException {
        StreamUtils.write((long)this.entryId, (OutputStream)bos);
        StreamUtils.write((UUID)this.sellerUUID, (OutputStream)bos);
        StreamUtils.write((UUID)this.buyerUUID, (OutputStream)bos);
        this.offeredStack.write(bos);
        StreamUtils.write((short)((short)this.amount), (OutputStream)bos);
        StreamUtils.write((long)this.price, (OutputStream)bos);
    }

    public void read(BufferedInputStream bis) throws IOException {
        this.entryId = StreamUtils.readLong((InputStream)bis);
        this.sellerUUID = StreamUtils.readUUID((InputStream)bis);
        this.buyerUUID = StreamUtils.readUUID((InputStream)bis);
        this.offeredStack = ItemStackWrapper.read((BufferedInputStream)bis);
        this.amount = StreamUtils.readShort((InputStream)bis);
        this.price = StreamUtils.readLong((InputStream)bis);
    }

    public void write(ByteBuf buffer) {
        buffer.writeLong(this.entryId);
        ByteBufUtils.writeString((String)this.sellerUsername, (ByteBuf)buffer);
        ByteBufUtils.writeString((String)this.buyerUsername, (ByteBuf)buffer);
        this.offeredStack.write(buffer);
        buffer.writeShort(this.amount);
        buffer.writeLong(this.price);
    }

    public void read(ByteBuf buffer) {
    }
}

