/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.server;

import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_trade.common.config.TradeConfig;
import austeretony.oxygen_trade.common.main.TradeMain;
import austeretony.oxygen_trade.server.SalesHistoryEntryServer;
import austeretony.oxygen_trade.server.TradeManagerServer;
import java.util.Iterator;

public class SalesHistoryManagerServer {
    private final TradeManagerServer manager;

    public SalesHistoryManagerServer(TradeManagerServer manager) {
        this.manager = manager;
    }

    public void processExpiredEntries() {
        OxygenHelperServer.addRoutineTask(() -> {
            if (this.manager.getSalesHistoryContainer().getEntriesAmount() > 0) {
                Iterator<SalesHistoryEntryServer> iterator = this.manager.getSalesHistoryContainer().getEntries().iterator();
                long currTimeMillis = System.currentTimeMillis();
                long expireTimeMillis = (long)TradeConfig.SALES_HISTORY_EXPIRE_TIME_HOURS.getIntValue() * 3600000L;
                int removed = 0;
                while (iterator.hasNext()) {
                    SalesHistoryEntryServer entry = iterator.next();
                    if (currTimeMillis - entry.getId() <= expireTimeMillis) continue;
                    iterator.remove();
                    ++removed;
                }
                if (removed > 0) {
                    this.manager.getSalesHistoryContainer().setChanged(true);
                }
                TradeMain.LOGGER.info("Removed {} expired sales entries.", (Object)removed);
            }
        });
    }
}

