/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.server.category;

import austeretony.oxygen_core.common.util.JsonUtils;
import austeretony.oxygen_core.server.preset.PresetServer;
import austeretony.oxygen_core.server.preset.PresetsManagerServer;
import austeretony.oxygen_trade.server.category.OfferCategoryServer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ItemCategoriesPresetServer
implements PresetServer {
    private long versionId;
    private final List<OfferCategoryServer> categories = new ArrayList<OfferCategoryServer>(3);
    private final ByteBuf compressed = Unpooled.buffer();

    public int getId() {
        return 100;
    }

    public String getDomain() {
        return "trade";
    }

    public String getDisplayName() {
        return "item_categories";
    }

    public long getVersionId() {
        return this.versionId;
    }

    public boolean load(String folder) {
        if (!this.loadVersionId(folder)) {
            return false;
        }
        String pathStr = folder + "item_categories.json";
        Path path = Paths.get(pathStr, new String[0]);
        this.categories.clear();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                for (JsonElement categoryEntry : JsonUtils.getExternalJsonData((String)pathStr).getAsJsonArray()) {
                    this.categories.add(OfferCategoryServer.deserialize(categoryEntry.getAsJsonObject()));
                }
                this.compress();
                return true;
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                JsonArray config = JsonUtils.getInternalJsonData((String)"assets/oxygen_trade/item_categories.json").getAsJsonArray();
                for (JsonElement categoryEntry : config) {
                    this.categories.add(OfferCategoryServer.deserialize(categoryEntry.getAsJsonObject()));
                }
                JsonUtils.createExternalJsonFile((String)pathStr, (JsonElement)config);
                this.compress();
                return true;
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadVersionId(String folder) {
        String pathStr = folder + "item_categories_version.txt";
        Path path = Paths.get(pathStr, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(pathStr));){
                this.versionId = Long.parseLong(bufferedReader.readLine());
                boolean bl = true;
                return bl;
            }
            catch (IOException exception) {
                exception.printStackTrace();
                return false;
            }
        }
        this.versionId = Long.parseLong(PresetsManagerServer.PRESET_DATE_FORMAT.format(new Date()));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (PrintStream printStream = new PrintStream(new File(pathStr));){
                printStream.println(this.versionId);
                return true;
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private void compress() {
        this.compressed.writeLong(this.versionId);
        this.compressed.writeByte(this.categories.size());
        for (OfferCategoryServer category : this.categories) {
            category.write(this.compressed);
        }
    }

    public void write(ByteBuf buffer) {
        buffer.writeBytes(this.compressed, 0, this.compressed.writerIndex());
    }
}

