/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_trade.server.category;

import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_trade.common.categories.EnumCategoriesFileKey;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;

public class OfferSubCategoryServer {
    public final String name;
    private final Set<String> registryNames = new HashSet<String>();

    public OfferSubCategoryServer(String name) {
        this.name = name;
    }

    protected static OfferSubCategoryServer deserialize(JsonObject jsonObject) {
        OfferSubCategoryServer subCategory = new OfferSubCategoryServer(jsonObject.get(EnumCategoriesFileKey.NAME.get()).getAsString());
        for (JsonElement itemEntry : jsonObject.get(EnumCategoriesFileKey.ITEMS.get()).getAsJsonArray()) {
            subCategory.registryNames.add(itemEntry.getAsString());
        }
        return subCategory;
    }

    protected void write(ByteBuf buffer) {
        ByteBufUtils.writeString((String)this.name, (ByteBuf)buffer);
        buffer.writeShort(this.registryNames.size());
        for (String registryName : this.registryNames) {
            ByteBufUtils.writeString((String)registryName, (ByteBuf)buffer);
        }
    }
}

