/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client;

import at.dhyan.open_imaging.GifDecoder;
import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.client.Texture;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public class AnimatedTexture
extends Texture {
    private List<ByteBuffer> framesTextureData;
    private int frameCounter;

    public AnimatedTexture(File file) {
        super(file);
    }

    @Override
    public void load(File file) {
        this.framesTextureData = Lists.newArrayList();
        THREAD_SERVICE.submit(() -> {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                GifDecoder.GifImage decoder = GifDecoder.read(inputStream);
                this.width = decoder.getWidth();
                this.height = decoder.getHeight();
                int frameCount = decoder.getFrameCount();
                for (int i = 0; i < frameCount; ++i) {
                    BufferedImage image = AnimatedTexture.parseFrame(decoder.getFrame(i));
                    int[] imageData = new int[this.width * this.height];
                    image.getRGB(0, 0, this.width, this.height, imageData, 0, this.width);
                    this.framesTextureData.add(this.createBuffer(imageData));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void update() {
        if (this.framesTextureData.size() > 0) {
            if (++this.frameCounter >= this.framesTextureData.size()) {
                this.frameCounter = 0;
            }
            ByteBuffer buffer = this.framesTextureData.get(this.frameCounter);
            GlStateManager.func_179144_i((int)this.getTextureId());
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        }
        if (this.counter++ >= 600) {
            this.delete = true;
            GlStateManager.func_179150_h((int)this.getTextureId());
        }
    }

    private static BufferedImage parseFrame(BufferedImage bufferedImage) {
        RGBImageFilter filter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                if ((rgb >> 24 & 0xFF) != 255) {
                    return 0;
                }
                return rgb;
            }
        };
        FilteredImageSource producer = new FilteredImageSource(bufferedImage.getSource(), filter);
        Image image = Toolkit.getDefaultToolkit().createImage(producer);
        BufferedImage resultBufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics = resultBufferedImage.createGraphics();
        graphics.drawImage(image, 0, 0, null);
        graphics.dispose();
        return resultBufferedImage;
    }
}

