/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Texture {
    protected static final ExecutorService THREAD_SERVICE = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName("Texture File I/O");
        return thread;
    });
    private ByteBuffer buffer;
    private int textureId = -1;
    protected int width;
    protected int height;
    protected int counter;
    protected boolean delete;

    public Texture(File file) {
        this.load(file);
    }

    public void load(File file) {
        THREAD_SERVICE.submit(() -> {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                BufferedImage image = ImageIO.read(inputStream);
                this.width = image.getWidth();
                this.height = image.getHeight();
                int[] imageData = new int[this.width * this.height];
                image.getRGB(0, 0, this.width, this.height, imageData, 0, this.width);
                this.buffer = this.createBuffer(imageData);
                Minecraft.func_71410_x().func_152344_a(() -> {
                    GlStateManager.func_179144_i((int)this.getTextureId());
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.buffer);
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public void update() {
        if (this.counter++ >= 600) {
            this.delete = true;
            GlStateManager.func_179150_h((int)this.getTextureId());
        }
    }

    protected ByteBuffer createBuffer(int[] data) {
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.width * this.height * 4));
        for (int y = this.height - 1; y >= 0; --y) {
            for (int x = this.width - 1; x >= 0; --x) {
                int color = data[x + y * this.width];
                buffer.put((byte)(color >> 16 & 0xFF));
                buffer.put((byte)(color >> 8 & 0xFF));
                buffer.put((byte)(color & 0xFF));
                buffer.put((byte)(color >> 24 & 0xFF));
            }
        }
        buffer.flip();
        return buffer;
    }

    public void bind() {
        this.counter = 0;
        GlStateManager.func_179144_i((int)this.getTextureId());
    }

    public int getTextureId() {
        if (this.textureId == -1 || !GL11.glIsTexture((int)this.textureId)) {
            this.textureId = GlStateManager.func_179146_y();
        }
        return this.textureId;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isPendingDeletion() {
        return this.delete;
    }
}

