/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.gui;

import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.gui.GuiRecipeBook;
import com.mrcrayfish.furniture.init.FurnitureItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class RecipePage {
    protected ArrayList<RecipeData> recipes = new ArrayList();
    public String type;
    protected int spacing = 30;
    private ItemStack drink = new ItemStack(FurnitureItems.DRINK);

    public RecipePage(String type) {
        this.type = type;
    }

    public void init(List<GuiButton> buttonList) {
    }

    public abstract void draw(GuiRecipeBook var1, int var2, int var3, int var4, int var5, float var6);

    public abstract void drawOverlay(Minecraft var1, GuiRecipeBook var2, int var3, int var4, int var5, int var6, float var7);

    public void onShown() {
    }

    public void onClose() {
    }

    public void handleButtonClick(GuiButton button) {
    }

    public abstract String getTitle();

    public boolean shouldDrawTitle() {
        return true;
    }

    public void addRecipe(RecipeData data) {
        this.recipes.add(data);
    }

    public String fixName(String name) {
        if (name.length() > 18) {
            name = name.substring(0, 18) + "...";
        }
        return name;
    }

    public ItemStack getDrink(String name, int red, int green, int blue) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("Colour", new int[]{red, green, blue});
        nbt.func_74778_a("Name", name);
        this.drink.func_77982_d(nbt);
        return this.drink;
    }

    public void drawToolTip(GuiRecipeBook gui, Minecraft mc, int x, int y, int mouseX, int mouseY, ItemStack stack) {
        if (gui.isMouseWithin(x, y, 16, 16, mouseX, mouseY)) {
            gui.func_146285_a(stack, mouseX, mouseY);
        }
    }
}

